% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_data_processing.R
\name{generate}
\alias{generate}
\title{Generating an artificial scanner dataset}
\usage{
generate(
  pmi = c(),
  psigma = c(),
  qmi = c(),
  qsigma = c(),
  prec = c(2, 0),
  n = 100,
  n0 = 1,
  r = 1,
  r0 = 1,
  start,
  days = FALSE
)
}
\arguments{
\item{pmi}{A numeric vector indicating \code{mi} parameters for lognormally distributed prices from the subsequent months.}

\item{psigma}{A numeric vector indicating \code{sigma} parameters for lognormally distributed prices from the subsequent months.}

\item{qmi}{A numeric vector indicating \code{mi} parameters for lognormally distributed quantities from the subsequent months.}

\item{qsigma}{A numeric vector indicating \code{sigma} parameters for lognormally distributed quantities from the subsequent months.}

\item{prec}{A two-dimensional numeric vector indicating precision, i.e. the number of decimal places, for presenting prices and quantities.}

\item{n}{An integer parameter indicating the number of products which are to be generated.}

\item{n0}{An integer parameter indicating the first (the smallest) prodID.}

\item{r}{An integer parameter indicating the number of outlets (retailer sale points) for which prices and quantities are to be generated.}

\item{r0}{n0 An integer parameter indicating the first (the smallest) retID.}

\item{start}{The first period in the generated data frame (as character) limited to the year and month, e.g. '2019-12'.}

\item{days}{A logical parameter indicating whether the trading day in a given month is to be randomised. The default value of \code{days} is FALSE, which means that each transaction for a given month takes place on the first day of the month.}
}
\value{
This function returns an artificial scanner dataset where prices and quantities are lognormally distributed. The characteristics for these lognormal distributions are set by \code{pmi}, \code{sigma}, \code{qmi} and \code{qsigma} parameters. This function works for a fixed number of products and outlets (see \code{n} and \code{r} parameters). The generated dataset is ready for further price index calculations.
}
\description{
This function provides artificial scanner datasets where prices and quantities are lognormally distributed.
}
\examples{
generate(pmi=c(1.02,1.03,1.04),psigma=c(0.05,0.09,0.02),qmi=c(3,4,4),
qsigma=c(0.1,0.1,0.15),start="2020-01",days=TRUE)
\donttest{generate(pmi=c(1.02,1.03,1.04),psigma=c(0.05,0.09,0.02),qmi=c(6,6,7),
qsigma=c(0.1,0.1,0.15),start="2020-01",n=1000,n0=132578,r=10)}
}
