% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxAUC.R
\name{toxAUC}
\alias{toxAUC}
\title{Create longitudinal mean score line plots for PRO-CTCAE data with modified
Area Under the Curve (AUC) estimates showing descriptive symptomatic adverse
event burden worsening and improvement from baseline.}
\usage{
toxAUC(
  dsn,
  id_var,
  cycle_var,
  baseline_val,
  arm_var = NA,
  cycle_limit = NA,
  y_limit = 4,
  tab_ymin = NA,
  tab_ymax = NA,
  round_dec = 2,
  overwrite_title = NA,
  permute_tests = FALSE,
  permute_n = 2000,
  bootstrap_ci = FALSE,
  bootstrap_ci_alpha = 0.05,
  bootstrap_n = 2000
)
}
\arguments{
\item{dsn}{A data.frame object with PRO-CTCAE data}

\item{id_var}{A character string. Name of ID variable differentiating each
unique patient.}

\item{cycle_var}{A character string. Name of variable differentiating one
longitudinal/repeated. PRO-CTCAE survey from another, within an individual
ID.}

\item{baseline_val}{A number indicating the expected baseline cycle/time
point.}

\item{arm_var}{A character string. Name of arm variable differentiating
treatment groups. Must be character or factor class. Overall frequencies
will be reported if no arm/grouping variable is provided. Defaults to
\code{NA}.}

\item{cycle_limit}{A number. Limit the number of cycles to be use to
calculate the AUC metrics up to and including a given cycle number.
All available cycle time points are used if no cycle number is provided.
Defaults to \code{NA}.}

\item{y_limit}{A number. Y axis limit for plots. Defaults to \code{4}.}

\item{tab_ymin}{A number. Y axis coordinate for adjusting the vertical
placement of the AUC table within the figure. Defaults to \code{NA}.}

\item{tab_ymax}{A number. Y axis coordinate for adjusting the vertical
placement of the AUC table within the figure. Defaults to \code{NA}.}

\item{round_dec}{A number. Number of decimal places to be shown within
the AUC table. Defaults to \code{2}.}

\item{overwrite_title}{A character string. Add main title to plots. Defaults
to \code{NA}.}

\item{permute_tests}{Logical. Calls to calculate p values comparing the
difference in AUC between two arms using a permutation test. Typical two-
sided null hypothesis for a permutation test is applied. That is, assigning
subjects to groups is interchangeable when calculating AUC. Computation
time may be extensive depending on data size, number of PRO-CTCAE items,
and number of permutations called. Consider staring out an open window or
crafting a haiku during this time. Defaults to \code{FALSE}.}

\item{permute_n}{A number. The number of permutations to be used for
permutation tests. Defaults to \code{2000}.}

\item{bootstrap_ci}{Logical. Calls to construct alpha-level confidence
intervals for the difference in AUC between arms. Similar considerations
for computation time as \code{permute_tests} are recommended here. Defaults
to \code{FALSE}.}

\item{bootstrap_ci_alpha}{A number. Specifies the alpha level for bootstrap
confidence intervals. Must be between 0 and 1. Defaults to \code{0.05}.}

\item{bootstrap_n}{A number. The number of bootstrap iterations to be used
for bootstrap confidence intervals. Defaults to \code{2000}.}
}
\description{
Data format should be in 'long' format, where each PRO-CTCAE item is a
	  variable/column.
}
\examples{
\dontrun{
AUC=toxAUC(dsn = ProAE::tox_acute,
id_var = "id",
cycle_var = "Cycle",
baseline_val = 1)
AUC[[1]]
}
}
