% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/comp.rand.subnet.R
\name{comp.rand.subnet}
\alias{comp.rand.subnet}
\title{Comparing a sub network to the randomly simulated ones}
\usage{
comp.rand.subnet(subgraph, graph, nsim = 1000, degree = FALSE,
  betweenness = FALSE, ave.path.len = FALSE, eccentricity = FALSE,
  cc = FALSE, method = "utest", FDR = 0.05)
}
\arguments{
\item{subgraph}{An igraph object.}

\item{graph}{An igraph object. The whole one for random simulation.}

\item{nsim}{Times for simulation. Default value is \code{1000}.}

\item{degree}{Logical value, indicating whether to do vertex degree comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{betweenness}{Logical value, indicating whether to do betweenness comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{ave.path.len}{Logical value, indicating whether to do average path comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{eccentricity}{Logical value, indicating whether to do eccentricity comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{cc}{Logical value, indicating whether to do clustering coefficient comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{method}{Test method, currently only \code{utest} is supported.}

\item{FDR}{False discovery rate. Default value is \code{0.05}.}
}
\value{
A matrix of compared parameters and plots.
}
\description{
Comparing a sub network with randomly simulated ones from the whole network.
}
\examples{
g<-barabasi.game(100,power=0.8,directed=FALSE)
	subg<-induced.subgraph(g,sample(1:100,30))
	comp.rand.subnet(subg,g)
comp.rand.subnet(subg,g,degree=TRUE)
}
\references{
Y Benjamini, Y Hochberg. Controlling the False Discovery Rate: A Practical and Powerful Approach to Multiple Testing. Journal of the Royal Statistical Society. Series B (Methodological), Vol. 57, No. 1. (1995), pp. 289-300.
}
\seealso{
\code{\link{net.comparing}}, \code{\link{comp.subnet}}
}

