% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/net.attack.R
\name{net.attack}
\alias{net.attack}
\title{Network attack}
\usage{
net.attack(graph, mode = c("exact", "sample"), sample.number = 10,
  nodes = NULL, vertex.name = NULL, ...)
}
\arguments{
\item{graph}{An igraph object.}

\item{mode}{Attack mode, possible values are \code{exact} and \code{sample}.}

\item{sample.number}{Number of attacked vertex, if \code{mode} is \code{sample}.}

\item{nodes}{Index of attacked vertex, if \code{mode} is \code{exact}.}

\item{vertex.name}{Name of attacked vertex, if \code{mode} is \code{exact}.}

\item{...}{Other arguments.}
}
\value{
An igraph object.
}
\description{
Retrieve the network after vertex attack.
}
\examples{
g<-barabasi.game(100,power=0.8,directed=FALSE)
g1<-net.attack(g,mode="sample",sample.number=10)
g1<-net.attack(g,mode="exact",nodes=sample(1:100,20))
}

