#' Tehran housing data
#'
#' A dataset containing Tehran housing data. The data set has 372 observations.
#' There are 26 explanatory variables at baseline, including 7 project physical and financial
#' features (V2-V8) and 19 economic variables and indices (V11-V29).
#' The outcome (V9) is the sales price of a real estate single-family
#' residential apartment.
#'
#' @source \url{http://archive.ics.uci.edu/ml/datasets/Residential+Building+Data+Set}
#' @format
#' \describe{
#'  \item{V9}{Actual sales price}
#'  \item{V2}{Total floor area of the building}
#'  \item{V3}{Lot area}
#'  \item{V4}{Total Preliminary estimated construction cost based on the prices at the beginning of the project}
#'  \item{V5}{Preliminary estimated construction cost based on the prices at the beginning of the project}
#'  \item{V6}{Equivalent preliminary estimated construction cost based on the prices at the beginning of the project in a selected base year}
#'  \item{V7}{Duration of construction}
#'  \item{V8}{Price of the unit at the beginning of the project per square meter}
#'  \item{V11}{The number of building permits issued}
#'  \item{V12}{Building services index for preselected base year}
#'  \item{V13}{Wholesale price index of building materials for the base year}
#'  \item{V14}{Total floor areas of building permits issued by the city/municipality}
#'  \item{V15}{Cumulative liquidity}
#'  \item{V16}{Private sector investment in new buildings}
#'  \item{V17}{Land price index for the base year}
#'  \item{V18}{The number of loans extended by banks in a time resolution}
#'  \item{V19}{The amount of loans extended by banks in a time resolution}
#'  \item{V20}{The interest rate for loan in a time resolution}
#'  \item{V21}{The average construction cost by private sector at the completion of construction}
#'  \item{V22}{The average cost of buildings by private sector at the beginning of construction}
#'  \item{V23}{Official exchange rate with respect to dollars}
#'  \item{V24}{Nonofficial (street market) exchange rate with respect to dollars}
#'  \item{V25}{Consumer price index (CPI) in the base year}
#'  \item{V26}{CPI of housing, water, fuel & power in the base year}
#'  \item{V27}{Stock market index}
#'  \item{V28}{Population of the city}
#'  \item{V29}{Gold price per ounce}
#' }

"t.housing"
