% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{clearSamples}
\alias{clearSamples}
\alias{clearSamples,PTModule-method}
\title{Clear all samples from module}
\usage{
\S4method{clearSamples}{PTModule}(mod)
}
\arguments{
\item{mod}{A \code{\link{PTModule}} object from which all samples needs
to be removed.}
}
\value{
Returns a copy of object \code{mod} in which all samples are removed.
}
\description{
Remove all \code{\link{PTSample}}s from a \code{\link{PTModule}} object.
}
\details{
Conform the original ProTracker, this method removes all patterns
\code{\link{PTSample}}s from a module. You keep all patterns
(\code{\link{PTPattern}}) and \code{\link{patternOrder}} info.
}
\examples{
data(mod.intro)

## 'clear.mod' is a copy of 'mod.intro' without the
## samples. It still holds all pattern tables and
## pattern order info.
clear.mod <- clearSamples(mod.intro)
}
\seealso{
Other module.operations: \code{\link{PTModule-class}},
  \code{\link{appendPattern}}, \code{\link{clearSong}},
  \code{\link{deletePattern}}, \code{\link{fix.PTModule}},
  \code{\link{modToWave}}, \code{\link{moduleSize}},
  \code{\link{patternLength}},
  \code{\link{patternOrderLength}},
  \code{\link{patternOrder}}, \code{\link{playMod}},
  \code{\link{playingtable}}, \code{\link{rawToPTModule}},
  \code{\link{read.module}}, \code{\link{trackerFlag}},
  \code{\link{write.module}}
}
\author{
Pepijn de Vries
}
