% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{as.data.frame.dist}
\alias{as.data.frame.dist}
\title{Converts a \code{dist} object to a \code{data.frame} object.}
\usage{
\method{as.data.frame}{dist}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{the \code{dist} object to be converted}

\item{row.names}{NULL or a \code{character} vector giving the row
names for the data frame. Missing values
are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and converting
column names (to syntactic names: see make.names)
is optional. Note that all of R's base package
as.data.frame() methods use optional only for column
names treatment, basically with the meaning of
data.frame(*, check.names = !optional).
See also the make.names argument of the
\code{\link[base]{matrix}} method.}

\item{...}{additional arguments to be passed to or from methods.}
}
\description{
The created \code{data.frame} has a attribute \code{is.dist} set to
the logical value \code{TRUE}.
}
\examples{
data(bacteria)
bacteria_rel_freq <- sweep(bacteria,
                           1,
                           rowSums(bacteria),
                           "/")
bacteria_hellinger <- sqrt(bacteria_rel_freq)
bacteria_dist <- dist(bacteria_hellinger)
bdf <- as.data.frame(bacteria_dist)

}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
