% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corls_test.R
\name{corls_test}
\alias{corls_test}
\title{Monte-Carlo Test on the sum of the singular values of a procustean rotation.}
\usage{
corls_test(
  ...,
  permutations = permute::how(nperm = 999),
  p_adjust_method = "holm"
)
}
\arguments{
\item{...}{the set of matrices or a \code{\link[ProcMod]{procmod_frame}}
object.}

\item{permutations}{a list of control values for the permutations as returned
by the function \code{\link[permute]{how}}, or the number of
permutations required.}

\item{p_adjust_method}{the multiple test correction method used
to adjust p values. \code{p_adjust_method}
belongs one of the folowing values: \code{"holm"},
\code{"hochberg"}, \code{"hommel"}, \code{"bonferroni"},
\code{"BH"}, \code{"BY"}, \code{"fdr"},  \code{"none"}.
The default is,set to \code{"holm"}.}
}
\description{
performs a Monte-Carlo Test on the sum of the singular values of a
procustean rotation (see \code{\link[ade4]{procuste.rtest}}).
}
\examples{
A <- simulate_matrix(10,3)
B <- simulate_matrix(10,5)
C <- simulate_correlation(B,10,r2=0.6)

# Computes the correlation matrix
data <- procmod_frame(A = A, B = B, C = C)

corls_test(data, permutations = 100)

}
\references{
{
 \insertRef{Jackson:95:00}{ProcMod}
}
}
\seealso{
\code{\link[stats]{p.adjust}}
}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
