% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_feature_diff.R
\name{expected_feature_diff}
\alias{expected_feature_diff}
\title{Expected number of not optimally balanced features as defined by a threshold}
\usage{
expected_feature_diff(n.feature, n.arm1, n.arm2, threshold)
}
\arguments{
\item{n.feature}{(\code{numeric}) total number of features}

\item{n.arm1}{(\code{numeric}) number of patients in comparison arm.}

\item{n.arm2}{(\code{numeric}) number of patients in control arm}

\item{threshold}{(\code{numeric}) positive number(s) for threshold to compare to.}
}
\value{
return a \code{numeric} vector for expected number of unbalanced features
}
\description{
Calculate expected number of features showing balance difference greater than a threshold
}
\note{
The output number indicates when running a randomized
trial with n.arm1 and n.arm2 samples in two arms and n.feature features
are of interest, the expected number of
features showing balance difference greater than threshold.
p = Prob(|Y|>threshold) is calculated from t distribution.
With n.feature features in total,
expected number of features with abs value > threshold can be calculated from Binomial(n.feature, p)
}
\examples{
expected_feature_diff(n.feature = 10, n.arm1 = 240, n.arm2 = 300, threshold = 0.2)
expected_feature_diff(n.feature = 10, n.arm1 = 240, n.arm2 = 300, threshold = c(0.1, 0.25))
}
