% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PsychWordVec.R
\name{data_wordvec_reshape}
\alias{data_wordvec_reshape}
\title{Reshape word vectors data.}
\usage{
data_wordvec_reshape(
  data,
  to = c("plain", "dense"),
  normalize = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data to be reshaped. See examples.}

\item{to}{Options include:
\itemize{
  \item{\code{"plain"} (default) reshapes the data
  from \code{data.table} (with two variables \code{word} and \code{vec},
  loaded by \code{\link{data_wordvec_load}})
  to \code{matrix} (with dimensions as columns and words as row names).}
  \item{\code{"dense"} just does the reverse.}
}}

\item{normalize}{Normalize all word vectors to unit length?
Defaults to \code{FALSE}. See \code{\link{data_wordvec_normalize}}.}

\item{verbose}{Print information to the console? Defaults to \code{TRUE}.}
}
\value{
A \code{data.table} (dense) or \code{matrix} (plain) of word vectors.
}
\description{
Reshape word vectors data from dense (\code{data.table})
to plain (\code{matrix}) or vice versa.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
d = head(demodata, 10)
d

d.plain = data_wordvec_reshape(d, to="plain")
d.plain

d.dense = data_wordvec_reshape(d.plain, to="dense")
d.dense  # identical to `d`

}
\seealso{
\code{\link{data_transform}}

\code{\link{data_wordvec_load}}

\code{\link{data_wordvec_normalize}}

\code{\link{data_wordvec_subset}}
}
