% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{method_extra_columns}
\alias{method_extra_columns}
\alias{get_method_extra_columns}
\alias{method_extra_columns.default}
\title{Method Extra Columns}
\usage{
get_method_extra_columns(method_name)

method_extra_columns(method_name)

\method{method_extra_columns}{default}(method_name)
}
\arguments{
\item{method_name}{Character string of the method name}
}
\value{
Character vector of extra column names, or empty character vector
if no extra columns are defined for the method
}
\description{
Retrieves the character vector of custom columns for a given method.
These are method-specific columns beyond the standard columns
(method, estimate, standard_error, ci_lower, ci_upper, p_value, BF,
convergence, note) that each method returns.

When implementing new methods, consider using standardized column names
for consistency: \describe{
\item{Heterogeneity}{\code{tau_estimate}, \code{tau_ci_lower}, \code{tau_ci_upper},
\code{tau_p_value}, \code{tau_BF}}
\item{Publication Bias}{\code{bias_coefficient}, \code{bias_coefficient_se},
\code{bias_p_value}, \code{bias_BF}}
}
}
\examples{
# Get extra columns for PET method
get_method_extra_columns("PET")

# Get extra columns for RMA method
get_method_extra_columns("RMA")

}
