% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{baseline}
\alias{baseline}
\title{Baseline correct the data}
\usage{
baseline(data = data, BaselineWindow = 0, BaselineType = NULL,
  DiffBaseOverride = FALSE)
}
\arguments{
\item{data}{A data frame object created from \code{downsample}.}

\item{BaselineWindow}{A numeric vector of length 1 or 2 specifying the time
points of the baseline window to be examined. Providing two values indicates
the start time and the end time of the baseline, respectively. Providing a single value
(i.e., time point) assumes that every preceding time point is part of the
baseline (N.B. trials may vary in the size of the baseline window and will
result in an error).}

\item{BaselineType}{A character string specifying Subtraction, Division, or
Normalization. Subtraction subtracts the average baseline value; Division
divides by the average baseline value; and Normalization subtracts and
divides by the average baseline value.}

\item{DiffBaseOverride}{A logical value indicating whether or not to
override the error produced when baseline windows differ in size.}
}
\value{
An object of type data table as described in \link[tibble]{tibble}.
}
\description{
\code{baseline} calculates the average pupil value for the window of Time
provided in BaselineWindow. The baseline value is then used in one of three
different calculation types that must be specified (Subtraction, Division,
or Normalization). Baselining is carried out separately for each event.
}
\examples{
# Load example data
data("Pupilex4")

dat <- baseline(Pupilex4, BaselineWindow = c(-500, 0),
                BaselineType = "Subtraction")

# Please see the vignettes for detailed example usage.
vignette("PupilPre_Basic_Preprocessing", package="PupilPre")

}
