% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATD.R
\name{ATD}
\alias{ATD}
\alias{dATD}
\alias{pATD}
\alias{qATD}
\alias{rATD}
\title{Quantile-based asymmetric Student's-t distribution}
\usage{
dATD(y, mu, phi, alpha, nu)

pATD(q, mu, phi, alpha, nu)

qATD(beta, mu, phi, alpha, nu)

rATD(n, mu, phi, alpha, nu)
}
\arguments{
\item{y, q}{These are each a vector of quantiles.}

\item{mu}{This is the location parameter \eqn{\mu}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{nu}{This is the degrees of freedom parameter \eqn{\nu}, which must be positive.}

\item{beta}{This is a vector of probabilities.}

\item{n}{This is the number of observations, which must be a positive integer that has length 1.}
}
\value{
\code{\link{dATD}} provides the density, \code{\link{pATD}} provides the cumulative distribution function, \code{\link{qATD}} provides the quantile function, and \code{\link{rATD}} generates a random sample from the quantile-based asymmetric Student's-\eqn{t} distribution.
The length of the result is determined by \eqn{n} for \code{\link{rATD}}, and is the maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Density, cumulative distribution function, quantile function and random sample generation
from the quantile-based asymmetric Student's-\eqn{t} distribution (ATD) proposed in Gijbels et al. (2019a).
}
\examples{
# Quantile-based asymmetric Student's-\\eqn{t} distribution (ATD)
# Density
rnum<-rnorm(100)
dATD(rnum,mu=0,phi=1,alpha=0.5,nu=10)

# Distribution function
pATD(rnum,mu=0,phi=1,alpha=0.5,nu=10)

# Quantile function
beta<-c(0.25,0.5,0.75)
qATD(beta=beta,mu=0,phi=1,alpha=.5,nu=10)

# random sample generation
rATD(n=100,mu=0,phi=1,alpha=.5,nu=10)

}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, to appear.
}
}
\seealso{
\code{\link{dQBAD}},  \code{\link{pQBAD}},  \code{\link{qQBAD}},  \code{\link{rQBAD}}
}
