% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AND.R
\name{momentAND}
\alias{momentAND}
\alias{meanAND}
\alias{varAND}
\alias{skewAND}
\alias{kurtAND}
\title{Moments estimation for the quantile-based asymmetric normal distribution.}
\usage{
meanAND(mu, phi, alpha)

varAND(mu, phi, alpha)

skewAND(alpha)

kurtAND(alpha)

momentAND(phi, alpha, r)
}
\arguments{
\item{mu}{This is the location parameter \eqn{\mu}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}

\item{r}{This is a value which is used to calculate \eqn{r}th moment about \eqn{\mu}.}
}
\value{
\code{\link{meanAND}} provides the mean, \code{\link{varAND}} provides the variance, \code{\link{skewAND}} provides the skewness, \code{\link{kurtAND}} provides the kurtosis, and  \code{\link{momentAND}} provides the \eqn{r}th moment about the location parameter \eqn{\mu} of the quantile-based asymmetric normal distribution.
}
\description{
Mean, variance, skewness, kurtosis and moments about the location parameter (i.e., \eqn{\alpha}th quantile) of the quantile-based asymmetric normal distribution introduced in Gijbels et al. (2019a) useful for quantile regression with location parameter equal to \eqn{\mu}, scale parameter \eqn{\phi} and index parameter \eqn{\alpha}.
}
\examples{
# Example
meanAND(mu=0,phi=1,alpha=0.5)
varAND(mu=0,phi=1,alpha=0.5)
skewAND(alpha=0.5)
kurtAND(alpha=0.5)
momentAND(phi=1,alpha=0.5,r=1)


}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, \url{https://doi.org/10.1111/insr.12324}.
}
}
