% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_germplasm_data}
\alias{get_germplasm_data}
\title{Get the observations data of a given germplasm name in a crop}
\usage{
get_germplasm_data(germplasm_name = "")
}
\arguments{
\item{germplasm_name}{the name of the germplasm}
}
\value{
a data frame of the germplasm observations data aggregate from all trials
}
\description{
This function will retrieve all the observations data available for a given germplasm
in the current crop database regardless of the programs/trials nested structure.
}
\examples{
if(interactive()) {
# config your BMS connection
set_qbms_config("https://www.bms-uat-test.net/ibpworkbench")

# login using your BMS account (interactive mode)
# you can pass BMS username and password as parameters (batch mode)
login_bms()

set_crop("maize")

# select a breeding program by name
set_program("MC Maize")

# retrive observations data of a given germplasm aggregated from all trials
germplasm_observations <- get_germplasm_data("BASFCORN-2-1")
}
}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{get_germplasm_attributes}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
