\name{Yamasaki}

\docType{data}

\alias{Yamasaki}

\title{Contradictory simplifying assumptions}

\description{
The \bold{Yamasaki} data frame has 6 rows and 6 columns.

In Qualitative Comparative Analysis (QCA) of social data, the generation of parsimonious 
explanatory equations is enhanced by the inclusion of  logical configurations. Even if this 
procedure proves to be very useful, it also raises various methodological issues. Among them,
the tricky problem of contradictory simplifying assumptions has remained largely unexplored.
Yet the careful control of this obstacle is crucial for any QCA to be successful, not only
because contradictory assumptions are inducing wrong conclusions, but also because their
resolution can generate most interesting results. Hence, our contribution aims at enlightening
this difficulty, as well as designing an efficient way to overcome it. In this perspective, we
start from data collected for a comparative research on the political feasibility of an
unconditional basic income in six OECD countries (1980-2002). After having briefly stated the
core elements of the research question, six operational variables are defined (section 1).
On this basis, we conduct a Boolean analysis and comment the various feasibility scenarios
generated by the QCA 3.0 software (section 2). Starting from these first results, we identify
contradictory simplifying assumptions used by the software, and discuss possible solutions to
this problem. New results are then generated (section 3). In the conclusion, we shortly discuss
the general implications of this methodological problem
}

\usage{data(Yamasaki)}

\format{
    The dataset contains the following columns:
    \tabular{ll}{
    NONGHENT \tab the absence of a Ghent system is coded "1" and "0" when the Ghent system exists
    in the country \cr
    MOVEMENT \tab in the presence of a social movement advocating Basic Income, the variable
    will be coded "1" \cr
    POSTMAT \tab the level of postmodern values in a society takes the value "1" in the Dutch and
    Finnish cases, and "0" in the others \cr
    UNITARY \tab Based on the Lijphart index (1.0 to 5.0, from unitary to federal and decentralised
    states), the variable is coded "0" for cases in the three following categories: semi-federal
    states (3.0), federal and centralized states (4.0), and federal and decentralized states (5.0),
    and "1" otherwise. \cr
    SOCIAL \tab Based on Esping-Andersen's categorisation of welfare regimes, the variable is coded
    "1" for non-liberal countries and "0" otherwise \cr
    AGENDA \tab 
    }
}

\source{\url{http://www.compasss.org}}

\references{
Vanderborght, Yannick and Sakura Yamasaki 2003 \emph{The Problem of Contradictory Simplifying
Assumptions in Qualitative Comparative Analysis (QCA)}, Paper presented at the ECPR General
onference, 18-21 Sept. 2003, Marburg, Germany

Vanderborght, Yannick and Sakura Yamasaki 2004 \emph{Des cas logiques...contradictoires? Un piege de 
l'AQQC dejoue a travers l'etude de la faisabilite politique de l'Allocation Universelle}, Revue 
Internationale de Politique Comparee, 2004, Vol.11, pp.51-66
}

\keyword{datasets}
