# S-Plus script developed by Professor Alexander McNeil, A.J.McNeil@hw.ac.uk
# R-version adapted by Scott Ulman (scottulman@hotmail.com)
# QRMlib 1.4.4
# This free script using QRMLib is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
# GNU General Public License for more details. 

######Load the QRMlib ##################
#QRMlib.pdf is a help file for the functions used by QRMlib.  It is available at
#...\Program Files\R\R-2.6.0\library\QRMlib\Docs
#If you have created the QRMBook workspace and .Rprofile  as described in QRMlib.pdf
#topics 'QRMBook-workspace' and 'profileLoadLibrary', then you may comment out the
#following line:
library(QRMlib);
#################################################

# Simulating Archimedean copulas with six variables:
data.gumbelcopula <- rcopula.gumbel(1000,theta=2, d=6)
data.claytoncopula <- rcopula.clayton(1000, theta=1, d=6)
data.frankcopula <- rcopula.frank(1000, theta=5, d=6)
pairs(data.gumbelcopula)
hist(data.gumbelcopula[,3])
pairs(data.claytoncopula)
pairs(data.frankcopula)

# Tests of multivariate normality.  Generate values via quantile function
#for normal marginals 
data.metagumbel <- apply(data.gumbelcopula,2,qnorm)
#produce QQ-plot assuming normal distribution; use only 1 column of data from matrix:
qqnorm(data.metagumbel[,1])
jointnormalTest(data.metagumbel)

# p-factor Archimedean

# 2 factor example, 2D, Gumbel (default so you don't need to pass name parameter:
#set weights for the asymmetry factors across the two dimensions: 
alpha <- c(0.95,0.7)
#row weights must sum to one in asymmetry matrix:
wtmatrix <- cbind(alpha,1-alpha)
data.gumbel.Arch2d <- rACp(10000,d=2,theta =c(4,1),A=wtmatrix)
plot(data.gumbel.Arch2d)
hist(data.gumbel.Arch2d[,1])
hist(data.gumbel.Arch2d[,2])


# 2 factor example, 4D, Gumbel
alpha <- c(0.1,0.7,0.8,0.9)
wtmatrix <- cbind(alpha,1-alpha)
data <- rACp(2000,d=4,theta =c(2,1),A=wtmatrix)
pairs(data)
hist(data[,4])

# 4 factor example, 3D, Clayton
wtmatrix <- cbind(c(0.1,0,0),c(0,0.2,0),c(0,0,0.3),c(0.9,0.8,0.7))
wtmatrix
data <- rACp(2000,d=3,theta =c(1,1,1,6),A=wtmatrix,name="clayton")
pairs(data)
hist(data[,3])

# 3 factor example, 3D, Gumbel
# Corresponds to logistic model (5.1) fitted in Tawn, Biometrika 1990
wtmatrix <- cbind(c(0,0,0.45),c(0.77,0.77,0),c(0.23,0.23,0.55))
wtmatrix
data <- rACp(2000,d=3,theta =c(1,1.27,7.44),A=wtmatrix,name="gumbel")
pairs(data)
hist(data[,3])
wtmatrix <- cbind(c(0,0,0.77),c(0.77,0.77,0),c(0.23,0.23,0.23))
wtmatrix
data <- rACp(2000,d=3,theta =c(1,1.27,7.44),A=wtmatrix,name="gumbel")
pairs(data)

# Gumbel 2 groups

data <- rcopula.Gumbel2Gp(n=3000,gpsizes=c(3,4),theta=c(2,3,5))
pairs(data)

# Gumbel Nested

data <- rcopula.GumbelNested(n=3000,theta=1:6)
pairs(data)

# Archimedean copulas generated by GIG distribution using Marshall-Olkin construction

lambda <- 0
chi <- 1
psi <- 1
data <- rAC("GIG",3000,3,c(lambda,chi,psi))
pairs(data)
hist(data[,1])
hist(data[,2])
hist(data[,3])
#######################Clayton#####################
chi <- 0
lambda <- 0.15
psi <- 1
data <- rAC("GIG",3000,3,c(lambda,chi,psi))
pairs(data)
hist(data[,1])
hist(data[,2])
hist(data[,3])
##########################Inverse gamma type##############
chi <- 1
lambda <- -0.15
psi <- 0
data <- rAC("GIG",3000,3,c(lambda,chi,psi))
pairs(data)
hist(data[,1])
hist(data[,2])
hist(data[,3])

