# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'
#' Compute the Gaussian kernel matrix between two samples
#'
#' @param x_mat A matrix containing the observations of X
#' @param y_mat A matrix containing the observations of Y
#' @param H Covariance matrix of the Gaussian kernel
#'
#' @return Matrix of computed Gaussian kernel values 
#'
#' @useDynLib QuadratiK
#' @rdname computeKernelMatrix
#' @keywords internal
#' 
#' @noRd
computeKernelMatrix <- function(x_mat, y_mat, H) {
    .Call(`_QuadratiK_computeKernelMatrix`, x_mat, y_mat, H)
}

#' Compute the Poisson kernel matrix between observations in a sample.
#'
#' @param x_mat A matrix containing the observations.
#' @param rho concentration parameter of the Poisson kernel.
#'
#' @return Matrix of computed Poisson kernel values
#'
#' @useDynLib QuadratiK
#' @rdname computePoissonMatrix
#' @keywords internal
#' 
#' @noRd
computePoissonMatrix <- function(x_mat, rho) {
    .Call(`_QuadratiK_computePoissonMatrix`, x_mat, rho)
}

#' Non-parametric centered kernel
#' 
#' Compute the values of the non-parametric centered kernel given the values of the 
#' kernel matrix. 
#'
#' @param kmat_zz A matrix containing the values of the kernel functions for each pair of observations
#' @param n_z The number of total observations
#'
#' @return Matrix of centered kernel
#'
#'
#'
#' @useDynLib QuadratiK
#' @rdname NonparamCentering
#' @keywords internal
#' 
#' @noRd
NonparamCentering <- function(kmat_zz, n_z) {
    .Call(`_QuadratiK_NonparamCentering`, kmat_zz, n_z)
}

#' Parametric centered kernel
#' 
#' Compute the Gaussian kernel centered with respect to a Normal distribution
#' with mean vector mu and covariance Sigma
#'
#' @param kmat_zz A matrix containing the values of the kernel functions for each pair of observations
#' @param z_mat Matrix of observations used for computing the kernel matrix
#' @param H Covariance matrix of the Normal kernel
#' @param mu_hat Mean of centering of Normal distribution
#' @param Sigma_hat Covariance of centering Normal distribution
#'
#' @return Matrix of centered kernel
#'
#' @useDynLib QuadratiK
#' @rdname ParamCentering
#' @keywords internal
#' 
#' @noRd
ParamCentering <- function(kmat_zz, z_mat, H, mu_hat, Sigma_hat) {
    .Call(`_QuadratiK_ParamCentering`, kmat_zz, z_mat, H, mu_hat, Sigma_hat)
}

#' Compute kernel-based quadratic distance test for Normality
#'
#' @param x_mat A matrix containing the observations.
#' @param h The bandwidth parameter for the Gaussian kernel function.
#' @param mu_hat Mean vector for the reference distribution (if available)
#' @param Sigma_hat Covariance matrix of the reference distribution (if available)
#' 
#' @return A scalar value representing the test statistic.
#'
#' @useDynLib QuadratiK
#' @rdname kbNormTest
#' @keywords internal
#' 
#' @noRd
kbNormTest <- function(x_mat, h, mu_hat, Sigma_hat) {
    .Call(`_QuadratiK_kbNormTest`, x_mat, h, mu_hat, Sigma_hat)
}

#' Poisson kernel-based test for Uniformity on the Sphere
#' 
#' Compute the Poisson kernel-based test for Uniformity given a sample of observations on the Sphere
#'
#' @param x_mat A matrix containing the observations.
#' @param rho Concentration parameter of the Poisson kernel.
#'
#' @return Vector with the values of the U-statistic and V-statistic
#'
#' @useDynLib QuadratiK
#' @rdname statPoissonUnif
#' @keywords internal
#' 
#' @noRd
statPoissonUnif <- function(x_mat, rho) {
    .Call(`_QuadratiK_statPoissonUnif`, x_mat, rho)
}

#'
#' Exact variance of two-sample test 
#' 
#' Compute the exact variance of kernel test for the two-sample problem under 
#' the null hypothesis that F=G.
#'
#' @param Kcen the matrix with centered kernel values
#' @param nsamples vector indicating sample's membership.
#'
#' @return the value of computed variance.
#' 
#' @keywords internal
var_two <- function(Kcen, nsamples) {
    .Call(`_QuadratiK_var_two`, Kcen, nsamples)
}

#' Compute kernel-based quadratic distance two-sample test with Normal kernel
#'
#' @param x_mat A matrix containing observations from the first sample
#' @param y_mat A matrix containing observations from the second sample
#' @param h The bandwidth parameter for the kernel function
#' @param centeringType String indicating the method used for centering the normal kernel
#' @param mu_hat Mean vector for the reference distribution 
#' @param Sigma_hat Covariance matrix of the reference distribution
#' @param compute_variance indicates if the nonparametric variance is computed.
#'                         Default is TRUE. 
#'
#' @return A scalar value representing the test statistic
#'
#' @details 
#' \code{mu_hat} and \code{Sigma_hat} need to be provided even if they are used 
#' only in case of "Param" \code{centeringType}.
#' 
#'
#' @useDynLib QuadratiK
#' @rdname stat2sample
#' @keywords internal
#' 
#' @noRd
stat2sample <- function(x_mat, y_mat, h, mu_hat, Sigma_hat, centeringType = "Nonparam", compute_variance = TRUE) {
    .Call(`_QuadratiK_stat2sample`, x_mat, y_mat, h, mu_hat, Sigma_hat, centeringType, compute_variance)
}

#'
#' Exact variance of k-sample test 
#' 
#' Compute the exact variance of kernel test for the k-sample problem under 
#' the null hypothesis that F1=...=Fk.
#'
#' @param Kcen the matrix with centered kernel values
#' @param sizes vector indicating sample's size.
#' @param cum_size vector indicating sample's cumulative sizes.
#'
#' @return the value of computed variance.
#' 
#' @keywords internal
var_k <- function(Kcen, sizes, cum_size) {
    .Call(`_QuadratiK_var_k`, Kcen, sizes, cum_size)
}

#' Kernel-based quadratic distance k-sample tests
#' 
#' Compute the kernel-based quadratic distance k-sample tests with the Normal kernel and bandwidth parameter h.
#'
#' @param x A matrix containing observations from the pooled sample, from the k samples.
#' @param y A vector containing observations' memberships to the k samples.
#' @param h The bandwidth parameter for the kernel function.
#' @param sizes Vector with sample sizes of the considered samples
#' @param cum_size Vector indicating the cumulative sizes, adding one sample at the time.
#' @param compute_variance indicates if the nonparametric variance is computed.
#'                         Default is TRUE. 
#'
#' @return A vector containing the two k-sample test statistics
#'
#' @useDynLib QuadratiK
#' @rdname stat_ksample_cpp
#' @keywords internal
#' 
#' @noRd
stat_ksample_cpp <- function(x, y, h, sizes, cum_size, compute_variance = TRUE) {
    .Call(`_QuadratiK_stat_ksample_cpp`, x, y, h, sizes, cum_size, compute_variance)
}

