% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/choice.grid.R
\name{choice.grid}
\alias{choice.grid}
\title{Choice of the quantization grids}
\usage{
choice.grid(X, N, ng = 1, p = 2)
}
\arguments{
\item{X}{vector or matrix that we want to quantize.}

\item{N}{size of the quantization grids.}

\item{ng}{number of quantization grids needed.}

\item{p}{L_p norm optimal quantization.}
}
\value{
An array of dimension \code{d}*\code{N}*\code{ng} that
 corresponds to \code{ng} quantization grids.
}
\description{
This function provides \code{ng} optimal quantization
 grids for \code{X}, with \code{N} fixed.
}
\details{
This function works for any dimension of \code{X}. If the covariate
 is univariate, \code{X} is a vector while \code{X} is a matrix with \code{d}
 rows when the covariate is \code{d}-dimensional.
}
\examples{
X <- runif(300,-2,2)
N <- 10
ng <- 20
choice.grid(X,N,ng)
}
\references{
Charlier, I. and Paindaveine, D. and Saracco, J.,
\emph{Conditional quantile estimator based on optimal
quantization: from theory to practice}, Submitted.

Pages, G. (1998) \emph{A space quantization method for numerical
integration}, Journal of Computational and Applied Mathematics, 89(1), 1-38
}
\seealso{
\code{\link{QuantifQuantile}}, \code{\link{QuantifQuantile.d2}} and
\code{\link{QuantifQuantile.d}}
}

