% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/print.QuantifQuantile.R
\name{print.QuantifQuantile}
\alias{print.QuantifQuantile}
\title{Print of QuantifQuantile results}
\usage{
\method{print}{QuantifQuantile}(x, ...)
}
\arguments{
\item{x}{An object of class \code{QuantifQuantile}, which is the result of
the \code{\link{QuantifQuantile}}, \code{\link{QuantifQuantile.d2}} or
\code{\link{QuantifQuantile.d}} functions.}

\item{\dots}{Not used.}
}
\description{
This function displays a small description of QuantifQuantile results.
}
\examples{
set.seed(644972)
n <- 300
X <- runif(300,-2,2)
Y <- X^2+rnorm(n)
res <- QuantifQuantile(X,Y,testN=seq(10,25,by=5))
print(res)
}
\author{
Isabelle Charlier, Davy Paindaveine, Jerome Saracco
}
\references{
Charlier, I. and Paindaveine, D. and Saracco, J.,
\emph{Conditional quantile estimation through optimal quantization},
Journal of Statistical Planning and Inference, 2015 (156), 14-30.

Charlier, I. and Paindaveine, D. and Saracco, J.,
\emph{Conditional quantile estimator based on optimal
quantization: from theory to practice}, Submitted.
}
\seealso{
\code{\link{QuantifQuantile}}, \code{\link{QuantifQuantile.d2}} and
 \code{\link{QuantifQuantile.d}}

\code{\link{plot.QuantifQuantile}},
\code{\link{summary.QuantifQuantile}}
}

