% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms.R
\name{frequent_terms}
\alias{frequent_terms}
\title{frequent_terms}
\usage{
frequent_terms(dtm, variable = NULL, n = 25)
}
\arguments{
\item{dtm}{A \code{DocumentTermMatrix}.}

\item{variable}{An optional vector of values giving the groups for which most frequent
terms should be reported.}

\item{n}{The maximal number of terms to report (for each group, if applicable).}
}
\value{
A list of matrices, one for each level of the variable, with columns:
\itemize{
\item "\\% Term/Level": the percent of the term's occurrences in all terms occurrences in the level.
\item "\\% Level/Term": the percent of the term's occurrences that appear in the level
(rather than in other levels).
\item "Global \\%": the percent of the term's occurrences in all terms occurrences in the corpus.
\item "Level": the number of occurrences of the term in the level ("internal").
\item "Global": the number of occurrences of the term in the corpus.
\item "t value": the quantile of a normal distribution corresponding the probability "Prob.".
\item "Prob.": the probability of observing such an extreme (high or low) number of occurrences of
the term in the level, under an hypergeometric distribution.
}
}
\description{
List terms with the highest number of occurrences in the document-term matrix of
a corpus, possibly grouped by the levels of a variable.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
frequent_terms(dtm)
frequent_terms(dtm, meta(corpus)$Date)

}
