% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrecompressFiles.R
\name{PrecompressFiles}
\alias{PrecompressFiles}
\title{This function is an optional pre-prossessing step before running consensus align to identify peaks that likely need to be combined prior to running consensus align and will perform a rough combine of these peaks depending on the quant method as an output.}
\usage{
PrecompressFiles(inputFileList, RT1Penalty = 1, RT2Penalty = 10,
  similarityCutoff = 95, numCores = 1, commonIons = c(),
  quantMethod = "T", outputFiles = F)
}
\arguments{
\item{inputFileList}{A character vector with full file paths to chromatof files for processing.}

\item{RT1Penalty}{A numeric indicating penalty used for first retention time differences. Defaults to 1}

\item{RT2Penalty}{A numeric indicating penalty used for second retention time differences. Defaults to 100}

\item{similarityCutoff}{A numeric indicating the similarity threshold (max=100) to use for declaring peaks to combine. Defaults to 95}

\item{numCores}{Number of cores used to parallelize alignment. See parallel package for details. Defaults to 1}

\item{commonIons}{A numeric vector of ions to exclude from alignment scores. Can provide first column of output from FindProblemIons function.}

\item{quantMethod}{Character indicating the quant method used in computing peak areas on chromatof. Accepts "U", "T", or "A" for unique mass, total ion chromatograph or apexing mass. Defaults to "T". If "T" or "A", peaks meeting similarity thresholds will simply be summed. If "U", peaks with the same unique mass with be summed and a proportional conversion will be used before combining peaks with different unique masses.}

\item{outputFiles}{A boolean indicating if putative peak combinations should be outputted. Will be present at the same path as the input file with _Processed.txt appended to the end.}
}
\value{
Returns a data frame with peaks recommended to be combined. If outputFiles is TRUE, peaks returned will be combined and new sample files will be written to the original directory with "_Processed.txt" added to the file name.
}
\description{
This function is an optional pre-prossessing step before running consensus align to identify peaks that likely need to be combined prior to running consensus align and will perform a rough combine of these peaks depending on the quant method as an output.
}
\examples{
PrecompressFiles(inputFileList=system.file("extdata", "SampleA.txt", package="R2DGC"))
}
