% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcDT.R
\name{removeEmptyLevelsDT}
\alias{removeEmptyLevelsDT}
\title{Remove empty levels from all the factor columns of a data.table object}
\usage{
removeEmptyLevelsDT(inputDT)
}
\arguments{
\item{inputDT}{data.table object containing the data of interest. This is an obligatory argument, without default value.}
}
\value{
No value is returned.
}
\description{
Remove empty levels from all the factor columns of a data.table object
}
\examples{
library(data.table)
inputDT <- as.data.table(data.frame(x = seq(1, 20, 2), y = LETTERS[1:10]))
levels(inputDT$y)
removeEmptyLevelsDT(inputDT)
levels(inputDT$y)
removeEmptyLevelsDT(inputDT[x < 10])
levels(inputDT$y)

# You need to define a new data.table object
# in order to make the 'removeEmptyLevelsDT' function work.
reducedDT <- inputDT[x < 10]
levels(reducedDT$y)
removeEmptyLevelsDT(reducedDT)
levels(reducedDT$y)
}
