% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{default_fs_fun}
\alias{default_fs_fun}
\title{Default (example) feature selection function for RAFS}
\usage{
default_fs_fun(train_data, train_decision, seed)
}
\arguments{
\item{train_data}{input data where columns are variables and rows are observations (all numeric)}

\item{train_decision}{decision variable as a binary sequence of length equal to number of observations}

\item{seed}{a numerical seed}
}
\value{
A \code{\link{list}} with at least two fields:
\code{rel_vars} and \code{rel_vars_rank}, which are vectors and contain,
respectively, the indices of variables considered relevant and the rank
for each relevant variable.
}
\description{
See \code{\link{run_rafs}} for how it is used. Only the train portion of the
dataset is to be fed into this function.
}
\details{
The function MUST use this \code{train_data} and MAY ignore
the \code{train_decision}.

If the function depends on randomness, it MUST use the seed parameter to seed
the PRNG.

The function needs to return a \code{\link{list}} with at least two elements:
\code{rel_vars} and \code{rel_vars_rank}, which are vectors and contain,
respectively, the indices of variables considered relevant and the rank
for each relevant variable. The function MAY return a list with more elements.

Other examples of sensible functions are included in the tests of this package.
}
