% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_RGWAS.R
\name{manhattan3}
\alias{manhattan3}
\title{Draw the effects of epistasis (3d plot and 2d plot)}
\usage{
manhattan3(
  input,
  map,
  cum.pos,
  plot.epi.3d = TRUE,
  plot.epi.2d = TRUE,
  main.epi.3d = NULL,
  main.epi.2d = NULL,
  saveName = NULL
)
}
\arguments{
\item{input}{List of results of RGWAS.epistasis / RGWAS.twostep.epi. If the output of `RGWAS.epistasis` is `res`,
`input` corresponds to `res$scores`. If the output of `RGWAS.twostep.epi.` is `res`,
`input` corresponds to `res$epistasis$scores`. See: Value of \link[RAINBOWR]{RGWAS.epistasis}}

\item{map}{Data frame with the marker names in the first column. The second and third columns contain the chromosome and map position.
This is map information for SNPs which are tested epistatic effects.}

\item{cum.pos}{Cumulative position (over chromosomes) of each marker}

\item{plot.epi.3d}{If TRUE, draw 3d plot}

\item{plot.epi.2d}{If TRUE, draw 2d plot}

\item{main.epi.3d}{The title of 3d plot. If this argument is NULL, trait name is set as the title.}

\item{main.epi.2d}{The title of 2d plot. If this argument is NULL, trait name is set as the title.}

\item{saveName}{When drawing any plot, you can save plots in png format. In saveName, you should substitute the name you want to save.
When saveAt = NULL, the plot is not saved.}
}
\value{
Draw 3d plot and 2d plot to show epistatic effects
}
\description{
Draw the effects of epistasis (3d plot and 2d plot)
}
