% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsa.corr.r
\name{lsa.corr}
\alias{lsa.corr}
\title{Compute correlations between variables within specified groups}
\usage{
lsa.corr(
  data.file,
  data.object,
  split.vars,
  bckg.corr.vars,
  PV.root.corr,
  corr.type,
  weight.var,
  include.missing = FALSE,
  shortcut = FALSE,
  output.file,
  open.output = TRUE
)
}
\arguments{
\item{data.file}{The file containing \code{lsa.data} object. Either this or \code{data.object}
shall be specified, but not both. See details.}

\item{data.object}{The object in the memory containing \code{lsa.data} object. Either this or
\code{data.file} shall be specified, but not both. See details.}

\item{split.vars}{Categorical variable(s) to split the results by. If no split variables are
provided, the results will be for the overall countries' populations.
If one or more variables are provided, the results will be split by all
but the last variable and the percentages of respondents will be computed
by the unique values of the last splitting variable.}

\item{bckg.corr.vars}{Names of continuous background or contextual variables to compute the
correlation coefficients for. The results will be computed by all groups
specified by the splitting variables. See details.}

\item{PV.root.corr}{The root names for the sets of plausible values to compute the correlation
coefficients for. See details.}

\item{corr.type}{String of length one, specifying the type of the correlations to compute,
either \code{"Pearson"} (default) or \code{"Spearman"}.}

\item{weight.var}{The name of the variable containing the weights. If no name of a weight
variable is provide, the function will automatically select the default
weight variable for the provided data, depending on the respondent type.}

\item{include.missing}{Logical, shall the missing values of the splitting variables be included
as categories to split by and all statistics produced for them? The
default (\code{FALSE}) takes all cases on the splitting variables without
missing values before computing any statistics. See details.}

\item{shortcut}{Logical, shall the "shortcut" method for IEA TIMSS, TIMSS Advanced,
TIMSS Numeracy, eTIMSS PSI, PIRLS, ePIRLS, PIRLS Literacy and RLII be applied?
The default (\code{FALSE}) applies the "full" design when computing the
variance components and the standard errors of the estimates.}

\item{output.file}{Full path to the output file including the file name. If omitted, a file
with a default file name "Analysis.xlsx" will be written to the working
directory (\code{getwd()}).}

\item{open.output}{Logical, shall the output be open after it has been written? The default
(\code{TRUE}) opens the output in the default spreadsheet program
installed on the computer.}
}
\value{
A MS Excel (\code{.xlsx}) file (which can be opened in any spreadsheet program), as specified with the full path in the \code{output.file}. If the argument is missing, an Excel file with the generic file name "Analysis.xlsx" will be saved in the working directory (\code{getwd()}). The workbook contains three spreadsheets. The first one ("Estimates") contains a table with the results by country and the final part of the table contains averaged results from all countries' statistics. The results are presented as a correlation matrices by the splitting variables. The following columns can be found in the table, depending on the specification of the analysis:

\itemize{
\item \verb{<}Country ID\verb{>} - a column containing the names of the countries in the file for which statistics are computed. The exact column header will depend on the country identifier used in the particular study.
\item \verb{<}Split variable 1\verb{>}, \verb{<}Split variable 2\verb{>}... - columns containing the categories by which the statistics were split by. The exact names will depend on the variables in \code{split.vars}.
\item n_Cases - the number of cases in the sample used to compute the statistics.
\item Sum_\verb{<}Weight variable\verb{>} - the estimated population number of elements per group after applying the weights. The actual name of the weight variable will depend on the weight variable used in the analysis.
\item Sum_\verb{<}Weight variable\verb{>}\verb{_}SE - the standard error of the the estimated population number of elements per group. The actual name of the weight variable will depend on the weight variable used in the analysis.
\item Percentages_\verb{<}Last split variable\verb{>} - the percentages of respondents (population estimates) per groups defined by the splitting variables in \code{split.vars}. The percentages will be for the last splitting variable which defines the final groups.
\item Percentages_\verb{<}Last split variable\verb{>}\verb{_}SE - the standard errors of the percentages from above.
\item Variable - the variable names (background/contextual or PV root names) to be matched against the rows of the following columns, forming the correlation matrices together.
\item Correlation_\verb{<}Background variable\verb{>} - the correlation coefficient of each continuous \verb{<}Background variable\verb{>} specified in \code{bckg.corr.vars} against itself and each of the variables in the column "Variable". There will be one column with correlation coefficient estimate for each variable specified in \code{bckg.corr.vars} and/or set of PVs specified in \code{PV.root.corr}.
\item Correlation_\verb{<}Background variable\verb{>}\verb{_}SE - the standard error of the correlation of each continuous \verb{<}Background variable\verb{>} specified in \code{bckg.corr.vars}. There will be one column with the SE of the correlation coefficient estimate for each variable specified in \code{bckg.corr.vars} and/or set of PVs specified in \code{PV.root.corr}.
\item Correlation_\verb{<}root PV\verb{>} - the correlation coefficient of each set of PVs specified as PV root name in \code{PV.root.corr} against itself and each of the variables in the column "Variable". There will be one column with correlation coefficient estimate for each set of PVs specified in \code{PV.root.corr} and each other set of PVs specified in \code{PV.root.corr} and/or each continuous background variable specified in \code{bckg.corr.vars}.
\item Correlation_\verb{<}root PV\verb{>}\verb{_}SE - the standard error of the correlation of each set of PVs specified as PV root name in \code{PV.root.corr}. There will be one column with the SE of the correlation coefficient estimate for each set of root PVs specified in \code{PV.root.corr} and another set of PVs specified in \code{PV.root.corr} and/or each continuous background variable specified in \code{bckg.corr.vars}.
\item Correlation_\verb{<}root PV\verb{>}\verb{_}SVR - the sampling variance component for the correlation of the PVs with the same \verb{<}root PV\verb{>} specified in \code{PV.root.corr}. There will be one column with the sampling variance component for the correlation coefficient estimate for each set of PVs specified in \code{PV.root.corr} with the other variables (other sets of PVs or background/contextual variables).
\item Mean_\verb{<}root PV\verb{>}\verb{_}MVR - the measurement variance component for the correlation of the PVs with the same \verb{<}root PV\verb{>} specified in \code{PV.root.corr}. There will be one column with the measurement variance component for the correlation coefficient estimate for each set of PVs specified in \code{PV.root.corr} with the other variables (other sets of PVs or background/contextual variables).
\item Correlation_\verb{<}Background variable\verb{>}\verb{_}SVR - the sampling variance component for the correlation of the particular background variable with a set of PVs specified in \code{PV.root.corr} it is correlated with. There will be one column with the sampling variance component for the average estimate for each background/contextual variable correlated with a set of PVs specified in \code{PV.root.corr}.
\item Correlation_\verb{<}Background variable\verb{>}\verb{_}MVR - the measurement variance component for the correlation of the particular background variable PVs with a set of PVs specified in \code{PV.root.corr}. There will be one column with the measurement variance component for the correlation coefficient estimate for each background/contextual variable correlated with a set of PVs specified in \code{PV.root.corr}.
\item t_\verb{<}root PV\verb{>} - the \emph{t}-test value for the correlation coefficients of a set of PVs when correlating them with other variables (background/contextual or other sets of PVs).
\item t_\verb{<}Background variable\verb{>} - the \emph{t}-test value for the correlation coefficients of background variables when correlating them with other variables (background/contextual or other sets of PVs).
\item p_\verb{<}root PV\verb{>} - the \emph{p}-value for the correlation coefficients of a set of PVs when correlating them with other variables (background/contextual or other sets of PVs).
\item p_\verb{<}Background variable\verb{>} - the \emph{p}-value value for the correlation coefficients of background variables when correlating them with other variables (background/contextual or other sets of PVs).
}
The second sheet contains some additional information related to the analysis per country in columns:
\itemize{
\item DATA - used \code{data.file} or \code{data.object}.
\item STUDY - which study the data comes from.
\item CYCLE - which cycle of the study the data comes from.
\item WEIGHT - which weight variable was used.
\item DESIGN - which resampling technique was used (JRR or BRR).
\item SHORTCUT - logical, whether the shortcut method was used.
\item NREPS - how many replication weights were used.
\item ANALYSIS_DATE - on which date the analysis was performed.
\item START_TIME - at what time the analysis started.
\item END_TIME - at what time the analysis finished.
\item DURATION - how long the analysis took in hours, minutes, seconds and milliseconds.
}

The third sheet contains the call to the function with values for all parameters as it was executed. This is useful if the analysis needs to be replicated later.
}
\description{
\code{lsa.corr} computes correlation coefficients between variables within groups defined by one or more variables.
}
\details{
Either \code{data.file} or \code{data.object} shall be provided as source of data. If both of them are provided, the function will stop with an error message.

The function computes correlation coefficients by the categories of the splitting variables. The percentages of respondents in each group are computed within the groups specified by the last splitting variable. If no splitting variables are added, the results will be computed only by country.

Multiple continuous background variables and/or sets of plausible values can be provided to compute correlation coefficients for. Please note that in this case the results will slightly differ compared to using each pair of the same background continuous variables or PVs in separate analysis. This is because the cases with the missing values are removed in advance and the more variables are provided to compute correlations for, the more cases are likely to be removed. That is, the function support only listwisie deletion.

Computation of correlation coefficients involving plausible values requires providing a root of the plausible values names in \code{PV.root.corr}. All studies (except CivED, TEDS-M, SITES, TALIS and TALIS Starting Strong Survey) have a set of PVs per construct (e.g. in TIMSS five for overall mathematics, five for algebra, five for geometry, etc.). In some studies (say TIMSS and PIRLS) the names of the PVs in a set always start with character string and end with sequential number of the PV. For example, the names of the set of PVs for overall mathematics in TIMSS are BSMMAT01, BSMMAT02, BSMMAT03, BSMMAT04 and BSMMAT05. The root of the PVs for this set to be added to \code{PV.root.corr} will be "BSMMAT". The function will automatically find all the variables in this set of PVs and include them in the analysis. In other studies like OECD PISA and IEA ICCS and ICILS the sequential number of each PV is included in the middle of the name. For example, in ICCS the names of the set of PVs are PV1CIV, PV2CIV, PV3CIV, PV4CIV and PV5CIV. The root PV name has to be specified in \code{PV.root.corr} as "PV#CIV". More than one set of PVs can be added. Note, however, that providing multiple continuous variables for the \code{bckg.avg.corr} argument and multiple PV roots for the \code{PV.root.corr} argument will affect the results for the correlation coefficients for the PVs because the cases with missing on \code{bckg.corr.vars} will be removed and this will also affect the results from the PVs (i.e. listwise deletion). On the other hand, using only sets of PVs to correlate should not affect the results on any PV estimates because PVs shall not have any missing values.

A sufficient number of variable names (background/contextual) or PV roots have to be provided - either two background variables, or two PV roots, or mixture of them with total length of two (i.e. one background/contextual variable and one PV root).

If \code{include.missing = FALSE} (default), all cases with missing values on the splitting variables will be removed and only cases with valid values will be retained in the statistics. Note that the data from the studies can be exported in two different ways: (1) setting all user-defined missing values to \code{NA}; and (2) importing all user-defined missing values as valid ones and adding their codes in an additional attribute to each variable. If the \code{include.missing} is set to \code{FALSE} (default) and the data used is exported using option (2), the output will remove all values from the variable matching the values in its \code{missings} attribute. Otherwise, it will include them as valid values and compute statistics for them.

The \code{shortcut} argument is valid only for TIMSS, eTIMSS PSI, TIMSS Advanced, TIMSS Numeracy, PIRLS, ePIRLS, PIRLS Literacy and RLII. Previously, in computing the standard errors, these studies were using 75 replicates because one of the schools in the 75 JK zones had its weights doubled and the other one has been taken out. Since TIMSS 2015 and PIRLS 2016 the studies use 150 replicates and in each JK zone once a school has its weights doubled and once taken out, i.e. the computations are done twice for each zone. For more details see Foy & LaRoche (2016) and Foy & LaRoche (2017). If replication of the tables and figures is needed, the \code{shortcut} argument has to be changed to \code{TRUE}.
The function provides two-tailed \emph{t}-test and \emph{p}-values for the correlation coefficients.
}
\examples{
# Compute correlations between the complex student background scales
# "Home Educational Resources/SCL", "Students Sense of School Belonging/SCL" and
# "Students Value Mathematics/SCL" by sex of students in TIMSS 2015 grade 8
# using data file, omit missing from the splitting variable (female and male
# as answered by the students), without shortcut, and open the output after the
# computations are done
\dontrun{
lsa.corr(data.file = "C:/Data/TIMSS_2015_G8_Student_Miss_to_NA.RData", split.vars = "BSBG01",
bckg.corr.vars = c("BSBGHER", "BSBGSSB", "BSBGSVM"), include.missing = FALSE,
output.file = "C:/temp/test.xlsx", open.output = TRUE)
}

# Compute correlations between the complex student background scales
# "Home Educational Resources/SCL" and "Students Sense of School Belonging/SCL"
# and the plausible values in overall mathematics and overall science by student
# sex and frequency of using computer or tablet at home using TIMSS 2015 grade 8
# data loaded in memory, using the shortcut, include the missing values in the
# splitting variables, and use the senate weights
\dontrun{
lsa.corr(data.object = T15_G8_student_data, split.vars = c("BSBG01", "BSBG13A"),
bckg.corr.vars = c("BSBGHER", "BSBGSSB"), PV.root.corr = c("BSMMAT", "BSSSCI"),
weight.var = "SENWGT", include.missing = FALSE, shortcut = TRUE,
output.file = "C:/temp/test.xlsx", open.output = TRUE)
}

# Compute the correlations between student overall reading achievement, overall mathematics
# scores (i.e. using a set of PVs) and student family wealth, using PISA 2018 student data
# loaded as object in the memory, by country, and do not open the output after the computations
# are finished
\dontrun{
lsa.corr(data.object = CY07_MSU_STU_QQQ, bckg.corr.vars = "WEALTH",
PV.root.corr = c("PV#MATH", "PV#READ"), include.missing = TRUE,
output.file = "C:/temp/test.xlsx", open.output = FALSE)
}

}
\references{
LaRoche, S., Joncas, M., & Foy, P. (2016). Sample Design in TIMSS 2015. In M. O. Martin, I. V. S. Mullis, & M. Hooper (Eds.), \emph{Methods and Procedures in TIMSS 2015} (pp. 3.1-3.37). Chestnut Hill, MA: TIMSS & PIRLS International Study Center.
LaRoche, S., Joncas, M., & Foy, P. (2017). Sample Design in PIRLS 2016. In M. O. Martin, I. V. S. Mullis, & M. Hooper (Eds.), \emph{Methods and Procedures in PIRLS 2016} (pp. 3.1-3.34). Chestnut Hill, MA: Lynch School of Education, Boston College.
}
\seealso{
\code{\link{lsa.convert.data}}
}
