% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimSum.R
\name{SimSum}
\alias{SimSum}
\title{Summarize Arrays}
\usage{
SimSum(x, min.max = FALSE, n.sim = FALSE, probs = c(0.025, 0.5, 0.975),
  margin = ifelse(is.null(dim(x) | length(dim(x)) == 1), 2, length(dim(x))))
}
\arguments{
\item{x}{Object to summarize which can be a numerical vector, matrix or a multi-dimensional array}

\item{min.max}{Enables to include minimum and maximum in the output.}

\item{n.sim}{Enables to include the number of observations in the output.}

\item{probs}{Quantiles to output.}

\item{margin}{Margin of the input array over which the summary function is applied.}
}
\description{
The function calculates summary statistics from arbitrary arrays.
}
\details{
The function calculates by default the mean, standard
deviation and the specified qantiles which are by default the
median and the 95% interval.

If a mulit-dimensional array is specified as \code{x}, then the
function will by default calculate the summaries over the margin of
the largest dimension. For the case of a vector and a matrix, the
function will transpose the results for better readabiliy.
}
\examples{
\dontrun{
x1 <- rnorm(100)
SimSum(x1)

x2 <- matrix(rnorm(100), ncol=5)
SimSum(x2)

x3 <- array(rnorm(5*10*3), dim=c(5,10,3))
SimSum(x3)
SimSum(x3, margin=2)
}

}
\keyword{internal}
