% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_plot.R
\name{plot.EM}
\alias{plot.EM}
\title{Diagnostic plots for EM fits}
\usage{
\method{plot}{EM}(x, size = 1.25, link = c("identity", "logit", "log"), ...)
}
\arguments{
\item{x}{EM fit}

\item{size}{Optional argument passed to \code{ggplot2} routines
which control line thickness.}

\item{link}{Choice of an applied link function. Can take one of the
values \code{identity} (default), \code{logit} or \code{log}.}

\item{...}{Ignored.

Overlays the fitted mixture density with a histogram and a density
plot of the raw sample fitted. Applying a link function can be
beneficial, for example a \code{logit} (\code{log}) link for beta
(gamma) mixtures obtained from a Binomial (Poisson)
\code{\link{gMAP}} analysis.}
}
\value{
A list of \code{\link[ggplot2]{ggplot}} plots for
diagnostics of the EM run. Detailled EM diagnostic plots are
included only if the global option \code{RBesT.verbose} is set to
\code{TRUE}. These include plots of the parameters of each
component vs the iteration. The plot of the mixture density with a
histogram and a density of the fitted sample is always returned.
}
\description{
Produce diagnostic plots of EM fits returned from \code{\link{mixfit}}.
}
\section{Customizing \pkg{ggplot2} plots}{


The returned plot is a \pkg{ggplot2} object. Please refer to the
"Customizing Plots" vignette which is part of \pkg{RBesT}
documentation for an introduction. For simple modifications (change
labels, add reference lines, ...) consider the commands found in
\code{\link[bayesplot]{bayesplot-helpers}}. For more advanced
customizations please use the \pkg{ggplot2} package directly. A
description of the most common tasks can be found in the
\href{http://www.cookbook-r.com/Graphs/}{R Cookbook} and a full
reference of available commands can be found at the
\href{http://ggplot2.tidyverse.org/reference/}{ggplot2 documentation
site}.
}

\examples{

bmix <- mixbeta(rob=c(0.2, 1, 1), inf=c(0.8, 10, 2))
bsamp <- rmix(bmix, 1000)
bfit <- mixfit(bsamp, type="beta", Nc=2)
pl <- plot(bfit)

print(pl$mixdens)
print(pl$mix)

\dontrun{
# a number of additional plots are generated in verbose mode
options(RBesT.verbose=TRUE)
pl_all <- plot(bfit)

names(pl_all)
# [1] "a"   "b"   "w"   "m"   "N"   "Lm"  "lN"  "Lw"  "lli" "mixdens" "mix"
}

}
\seealso{
Other EM: \code{\link{mixfit}}
}
