% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pos2S.R
\name{pos2S}
\alias{pos2S}
\alias{pos2S.betaMix}
\alias{pos2S.normMix}
\alias{pos2S.gammaMix}
\title{Probability of Success for 2 Sample Design}
\usage{
pos2S(prior1, prior2, n1, n2, decision, ...)

\method{pos2S}{betaMix}(prior1, prior2, n1, n2, decision, eps, ...)

\method{pos2S}{normMix}(prior1, prior2, n1, n2, decision, sigma1, sigma2,
  eps = 1e-06, Ngrid = 10, ...)

\method{pos2S}{gammaMix}(prior1, prior2, n1, n2, decision, eps = 1e-06,
  ...)
}
\arguments{
\item{prior1}{Prior for sample 1.}

\item{prior2}{Prior for sample 2.}

\item{n1, n2}{Sample size of the respective samples. Sample size \code{n1} must be greater than 0 while sample size \code{n2} must be greater or equal to 0.}

\item{decision}{Two-sample decision function to use; see \code{\link{decision2S}}.}

\item{...}{Optional arguments.}

\item{eps}{Support of random variables are determined as the
interval covering \code{1-eps} probability mass. Defaults to
\eqn{10^{-6}}.}

\item{sigma1}{The fixed reference scale of sample 1. If left
unspecified, the default reference scale of the prior 1 is assumed.}

\item{sigma2}{The fixed reference scale of sample 2. If left
unspecified, the default reference scale of the prior 2 is assumed.}

\item{Ngrid}{Determines density of discretization grid on which
decision function is evaluated (see below for more details).}
}
\value{
Returns a function which when called with two arguments
\code{mix1} and \code{mix2} will return the frequencies at
which the decision function is evaluated to 1. Each argument is
expected to be a mixture distribution representing the assumed true
distribution of the parameter in each group.
}
\description{
The \code{pos2S} function defines a 2 sample design (priors, sample
sizes & decision function) for the calculation of the probability
of success. A function is returned which calculates the calculates
the frequency at which the decision function is evaluated to 1 when
parameters are distributed according to the given distributions.
}
\details{
The \code{pos2S} function defines a 2 sample design and
returns a function which calculates its probability of success.
The probability of success is the frequency with which the decision
function is evaluated to 1 under the assumption of a given true
distribution of the data implied by a distirbution of the
parameters \eqn{\theta_1} and \eqn{\theta_2}.

The calculation is analogous to the operating characeristics
\code{\link{oc2S}} with the difference that instead of assuming
known (point-wise) true parameter values a distribution is
specified for each parameter.

Calling the \code{pos2S} function calculates the decision boundary
\eqn{D_1(y_2)} and returns a function which can be used to evaluate the
PoS for different predictive distributions. It is evaluated as

\deqn{ \int\int\int f_2(y_2|\theta_2) \, p(\theta_2) \, F_1(D_1(y_2)|\theta_1) \, p(\theta_1) \, dy_2 d\theta_2 d\theta_1. }

where \eqn{F} is the distribution function of the sampling
distribution and \eqn{p(\theta_1)} and \eqn{p(\theta_2)} specifies
the assumed true distribution of the parameters \eqn{\theta_1} and
\eqn{\theta_2}, respectively. Each distribution \eqn{p(\theta_1)}
and \eqn{p(\theta_2)} is a mixture distribution and given as the
\code{mix1} and \code{mix2} argument to the function.

For example, in the binary case an integration of the predictive
distribution, the BetaBinomial, instead of the binomial
distribution will be performed over the data space wherever the
decision function is evaluated to 1. All other aspects of the
calculation are as for the 2-sample operating characteristics, see
\code{\link{oc2S}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{betaMix}: Applies for binomial model with a mixture
beta prior. The calculations use exact expressions.  If the
optional argument \code{eps} is defined, then an approximate method
is used which limits the search for the decision boundary to the
region of \code{1-eps} probability mass. This is useful for designs
with large sample sizes where an exact approach is very costly to
calculate.

\item \code{normMix}: Applies for the normal model with known
standard deviation \eqn{\sigma} and normal mixture priors for the
means. As a consequence from the assumption of a known standard
deviation, the calculation discards sampling uncertainty of the
second moment. The function has two extra arguments (with
defaults): \code{eps} (\eqn{10^{-6}}) and \code{Ngrid} (10). The
decision boundary is searched in the region of probability mass
\code{1-eps}, respectively for \eqn{y_1} and \eqn{y_2}. The
continuous decision function is evaluated at a discrete grid, which
is determined by a spacing with \eqn{\delta_2 =
\sigma_2/\sqrt{N_{grid}}}. Once the decision boundary is evaluated
at the discrete steps, a spline is used to inter-polate the
decision boundary at intermediate points.

\item \code{gammaMix}: Applies for the Poisson model with a gamma
mixture prior for the rate parameter.  The function
\code{pos2S} takes an extra argument \code{eps} (defaults to \eqn{10^{-6}}) which
determines the region of probability mass \code{1-eps} where the
boundary is searched for \eqn{y_1} and \eqn{y_2}, respectively.
}}

\examples{

# see ?decision2S for details of example
priorT <- mixnorm(c(1,   0, 0.001), sigma=88, param="mn")
priorP <- mixnorm(c(1, -49, 20   ), sigma=88, param="mn")
# the success criteria is for delta which are larger than some
# threshold value which is why we set lower.tail=FALSE
successCrit  <- decision2S(c(0.95, 0.5), c(0, 50), FALSE)

# example interim outcome
postP_interim <- postmix(priorP, n=10, m=-50)
postT_interim <- postmix(priorT, n=20, m=-80)

# assume that mean -50 / -80 were observed at the interim for
# placebo control(n=10) / active treatment(n=20) which gives
# the posteriors
postP_interim
postT_interim

# then the PoS to succeed after another 20/30 patients is
pos_final <- pos2S(postP_interim, postT_interim, 20, 30, successCrit)

pos_final(postP_interim, postT_interim)

}
\seealso{
Other design2S: \code{\link{decision2S_boundary}},
  \code{\link{decision2S}}, \code{\link{oc2S}}
}
\concept{design2S}
