% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notation.R
\name{row-col-notation}
\alias{row-col-notation}
\alias{notation_vec}
\alias{preposition_notation}
\alias{split_pref_suff}
\alias{paste_pref_suff}
\alias{flip_pref_suff}
\alias{get_pref_suff}
\alias{switch_notation}
\title{Row and column notation}
\usage{
notation_vec(
  sep = " -> ",
  pref_start = "",
  pref_end = "",
  suff_start = "",
  suff_end = ""
)

preposition_notation(preposition, suff_start = " [", suff_end = "]")

split_pref_suff(
  x,
  transpose = FALSE,
  inf_notation = TRUE,
  notation = RCLabels::notations_list,
  choose_most_specific = TRUE
)

paste_pref_suff(
  ps = list(pref = pref, suff = suff),
  pref = NULL,
  suff = NULL,
  notation = RCLabels::arrow_notation,
  squish = TRUE
)

flip_pref_suff(
  x,
  notation = RCLabels::notations_list,
  inf_notation = TRUE,
  choose_most_specific = TRUE
)

get_pref_suff(
  x,
  which = c("pref", "suff"),
  inf_notation = TRUE,
  notation = RCLabels::notations_list,
  choose_most_specific = TRUE
)

switch_notation(
  x,
  from = RCLabels::notations_list,
  to,
  flip = FALSE,
  inf_notation = TRUE
)
}
\arguments{
\item{sep}{A string separator between prefix and suffix. Default is " -> ".}

\item{pref_start}{A string indicating the start of a prefix. Default is \code{NULL}.}

\item{pref_end}{A string indicating the end of a prefix. Default is the value of \code{sep}.}

\item{suff_start}{A string indicating the start of a suffix. Default is the value of \code{sep}.}

\item{suff_end}{A string indicating the end of a suffix. Default is \code{NULL}.}

\item{preposition}{A string used to indicate position for energy flows, typically "from" or "to" in different notations.}

\item{x}{A string or vector of strings to be operated upon.}

\item{transpose}{A boolean that tells whether to \code{purr::transpose()} the result.
Set \code{transpose = TRUE} when using \code{split_pref_suff()} in a \code{dplyr::mutate()}
call in the context of a data frame.
Default is \code{FALSE}.}

\item{inf_notation}{A boolean that tells whether to infer notation for \code{x}.
Default is \code{TRUE}.
See \code{infer_notation()} for details.}

\item{notation}{A notation vector generated by one of the \verb{*_notation()} functions, such as
\code{notation_vec()}, \code{arrow_notation}, or \code{bracket_notation}.}

\item{choose_most_specific}{A boolean that tells whether to choose the most specific
notation from the \code{notation} argument when the \code{notation} argument is a list.}

\item{ps}{A list of prefixes and suffixes in which each item of the list is itself a list with two items named \code{pref} and \code{suff}.}

\item{pref}{A string or list of strings that are prefixes. Default is \code{NULL}.}

\item{suff}{A string of list of strings that are suffixes. Default is \code{NULL}.}

\item{squish}{A boolean that tells whether to remove extra spaces in the output of \verb{paste_*()} functions.
Default is \code{TRUE}.}

\item{which}{Tells which to keep, the prefix ("pref") or the suffix ("suff").}

\item{from}{The \code{notation} to switch \emph{away from}.}

\item{to}{The \code{notation} to switch \emph{to}.}

\item{flip}{A boolean that tells whether to also flip the notation. Default is \code{FALSE}.}
}
\value{
For \code{notation_vec()}, \code{arrow_notation}, and \code{bracket_notation},
a string vector with named items \code{pref_start}, \code{pref_end}, \code{suff_start}, and \code{suff_end};
For \code{split_pref_suff()}, a string list with named items \code{pref} and \code{suff}.
For \code{paste_pref_suff()}, \code{split_pref_suff()}, and \code{switch_notation()},
a string list in notation format specified by various \code{notation} arguments, including
\code{from}, and \code{to}.
For \code{keep_pref_suff}, one of the prefix or suffix or a list of prefixes or suffixes.
}
\description{
It is often convenient to represent matrix row and column names
with notation that includes a prefix and a suffix,
with corresponding separators or start-end string sequences.
There are several functions to generate specialized versions
or otherwise manipulate row and column names on their own or as row or column names.
\itemize{
\item \code{flip_pref_suff()} Switches the location of prefix and suffix, such that the prefix becomes the suffix, and
the suffix becomes the prefix.
E.g., "a -> b" becomes "b -> a" or "a [b]" becomes "b [a]".
\item \code{get_pref_suff()} Selects only prefix or suffix, discarding notational elements
and the rejected part.
Internally, this function calls \code{split_pref_suff()} and selects only the desired portion.
\item \code{notation_vec()} Builds a vector of notation symbols in a standard format.
By default, it builds a list of notation symbols that provides an arrow
separator (" -> ") between prefix and suffix.
\item \code{paste_pref_suff()} \code{paste0}'s prefixes and suffixes, the inverse of \code{split_pref_suff()}.
Always returns a character vector.
\item \code{preposition_notation()} Builds a list of notation symbols that provides (by default) square brackets around the suffix with a preposition ("prefix [preposition suffix]").
\item \code{split_pref_suff()} Splits prefixes from suffixes, returning each in a list with names \code{pref} and \code{suff}.
If no prefix or suffix delimiters are found, \code{x} is returned in the \code{pref} item, unmodified,
and the \code{suff} item is returned as \code{""} (an empty string).
If there is no prefix, and empty string is returned for the \code{pref} item.
If there is no suffix, and empty string is returned for the \code{suff} item.
\item \code{switch_notation()} Switches from one type of notation to another based on the \code{from} and \code{to} arguments.
Optionally, prefix and suffix can be \code{flip}ped.
}

Parts of a notation vector are
"pref_start", "pref_end", "suff_start", and "suff_end".
None of the strings in a notation vector are considered part of the prefix or suffix.
E.g., "a -> b" in arrow notation means that "a" is the prefix and "b" is the suffix.
If \code{sep} only is specified for \code{notation_vec()} (default is " -> "),
\code{pref_start}, \code{pref_end}, \code{suff_start}, and \code{suff_end} are
set appropriately.

For functions where the \code{notation} argument is used to identify portions of the row or column label
(such as \code{split_pref_suff()}, \code{get_pref_suff()},
and the \code{from} argument to \code{switch_notation()}),
(Note: \code{flip_pref_suff()} cannot infer notation, because it switches prefix and suffix in a known, single notation.)
if \code{notation} is a list, it is treated as a store from which
the most appropriate notation is inferred by \code{infer_notation(choose_most_specific = TRUE)}.
Because default is \code{RCLabels::notations_list},
notation is inferred by default.
The argument \code{choose_most_specific} tells what to do when two \code{notation}s match a label:
if \code{TRUE} (the default), the notation with most characters is selected.
If \code{FALSE}, the first matching notation in \code{notation} will be selected.
See details at \code{infer_notation()}.

For functions that construct labels (such as \code{paste_pref_suff()}),
\code{notation} can be a list of notations
over which the paste tasks is mapped.
If \code{notation} is a list, it must have as many items as
there are prefix/suffix pairs to be pasted.

If either \code{pref} or \code{suff} are a zero-length character vector
(essentially an empty character vector
such as obtained from \code{character()})
input to \code{paste_pref_suff()},
an error is thrown.
Instead, use an empty character string
(such as obtained from \code{""}).
}
\examples{
notation_vec()
arrow_notation
bracket_notation
split_pref_suff("a -> b", notation = arrow_notation)
# Or infer the notation (by default from notations_list)
split_pref_suff("a -> b")
split_pref_suff(c("a -> b", "c -> d", "e -> f"))
split_pref_suff(c("a -> b", "c -> d", "e -> f"), transpose = TRUE)
flip_pref_suff("a [b]", notation = bracket_notation)
# Infer notation
flip_pref_suff("a [b]")
get_pref_suff("a -> b", which = "suff")
switch_notation("a -> b", from = arrow_notation, to = bracket_notation)
# Infer notation and flip prefix and suffix
switch_notation("a -> b", to = bracket_notation, flip = TRUE)
# Also works for vectors
switch_notation(c("a -> b", "c -> d"),
                from = arrow_notation,
                to = bracket_notation)
# Functions can infer the correct notation and return multiple matches
infer_notation("a [to b]",
               allow_multiple = TRUE,
               choose_most_specific = FALSE)
# Or choose the most specific notation
infer_notation("a [to b]",
               allow_multiple = TRUE,
               choose_most_specific = TRUE)
# When setting the from notation, only that type of notation will be switched
switch_notation(c("a -> b", "c [to d]"),
                from = arrow_notation,
                to = bracket_notation)
# But if notations are inferred, all notations can be switched
switch_notation(c("a -> b", "c [to d]"), to = bracket_notation)
# A double-switch can be accomplished.
# In this first example, `RCLabels::first_dot_notation` is inferred.
switch_notation("a.b.c", to = arrow_notation)
# In this second example,
# it is easier to specify the `from` and `to` notations.
switch_notation("a.b.c", to = arrow_notation) \%>\%
  switch_notation(from = first_dot_notation, to = arrow_notation)
# "" can be used as an input
paste_pref_suff(pref = "a", suff = "", notation = RCLabels::from_notation)
}
