% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{states}
\alias{states}
\title{States dataset for R Companion to Political Analysis, Third Edition}
\format{
A data frame with 50 rows and 149 variables.
\describe{
  \item{abortion.rate}{Number of abortions per 1000 women 15-44, 2008}
  \item{abortlaws}{Number of restrictions on abortion}
  \item{abortlaws.3cat}{Restrictiveness of state abortion laws, 3 ordinal categories}
  \item{adv.or.more}{Percentage of 25+ population with graduate or professional degree}
  \item{alcohol}{Alcohol consumption (gal/capita) 2007}
  \item{attend.pct}{Percentage freq attend relig serv (Pew)}
  \item{ba.or.more}{Percentage of 25+ population with bachelor's degree or more}
  \item{battleground2020}{Battleground in 2020 election? }
  \item{biden2020}{Two-party vote share for Biden in 2020 election}
  \item{biden2020.ev}{Electoral College votes for Biden in 2020 election}
  \item{biz.tax.rank}{State business tax climate ranking}
  \item{biz.tax.score}{State business tax climate rating}
  \item{black.percent}{Percentage of population black or African American}
  \item{black.stateleg}{Percent of state legislators who are African American}
  \item{brady.rank}{Brady Campaign ranking}
  \item{brady.score}{Brady Campaign score}
  \item{broadband}{Percentage of households with broadband Internet subscription}
  \item{carfatal}{Motor vehicle fatalities (per 100,000 pop)}
  \item{carfatal07}{Motor vehicle fatalities per 100,000 pop (2007)}
  \item{cig.tax}{Cigarette tax per pack}
  \item{cig.tax.3cat}{Cigarette tax per pack, 3 ordinal categories}
  \item{cigarettes}{Packs bimonthly per adult pop}
  \item{citizen.ideology}{Citizen ideology index}
  \item{clinton2016}{Vote share for Clinton in 2016 election}
  \item{cong.dem}{Percentage of state's 2020 congressional delegation that is Democratic}
  \item{cook.index}{Higher scores more Dem}
  \item{cook.index3}{3 quantiles of cook_index}
  \item{corrections.incarc.rate}{Population incarcerated per 100,000 state residents }
  \item{corrections.total.rate}{Population under correctional supervision per 100,000 state residents}
  \item{covid.cases}{COVID cases (as of June 2021)}
  \item{covid.cases.per1000}{COVID cases per 1,000 persons (as of June 2021)}
  \item{covid.deaths}{COVID deaths (as of June 2021)}
  \item{covid.deaths.per1000}{COVID deaths per 1,000 persons (as of June 2021)}
  \item{covid.response.max}{Maximum of COVID response stringency index}
  \item{covid.response.mean}{Mean of COVID response stringency index }
  \item{covid.vaccinated}{Percentage of population fully vaccinated against COVID (as of June 2021)}
  \item{crime.rate.burglary}{Burglary rate, per 100,000 population}
  \item{crime.rate.murder}{Murder and non-negligent manslaughter rate, per 100,000 population}
  \item{crime.rate.property}{Property crime rates, per 100,000 population}
  \item{crime.rate.violent}{Violent crime rate, per 100,000 population}
  \item{deathpen.executions}{Executions since 1976}
  \item{deathpen.exonerations}{Death penalty exonerations since 1973}
  \item{deathpen.status}{Does state retain death penalty?}
  \item{defexpen}{Federal defense expenditures per capita}
  \item{dem.stateleg}{Percent of state legislators who are Democrats}
  \item{density}{Population per square mile}
  \item{division}{Census division}
  \item{drug.death.rate}{Drug overdose death rate per 100,000 adults}
  \item{earmarks.pcap}{Earmarks per capita (in dollars)}
  \item{foreign.born}{Percentage of population born outside the United States}
  \item{gay.policy}{Billman's policy scale}
  \item{gay.policy2}{RECODE of gay_policy (Billman's policy scale)}
  \item{gay.policy.con}{Does state have 'most conservative' gay policies?}
  \item{gay.support}{Lax-Phillips opinion index}
  \item{gay.support3}{Gay rights: public support}
  \item{giffords.grade}{Letter grade of state's gun control laws, from Giffords Law Center}
  \item{giffords.rank}{Ranking of state's gun control laws, from Giffords Law Center }
  \item{gini.2016}{GINI index score}
  \item{gini.rank.2016}{Income equality ranking }
  \item{govt.worker}{Precentage workforce government workers (2012)}
  \item{gun.bgchecks}{Background checks per 100,000 pop (2012)}
  \item{gun.dealers}{Gun dealers per 100,000 pop}
  \item{gun.deaths.100k}{Gun deaths per 100k}
  \item{gun.murders}{Gun murder rate (2010)}
  \item{gunlaws}{Number of state gun control laws}
  \item{gunlaws.3cat}{Number of state gun control laws, 3 ordinal categories}
  \item{gunsammo.rank}{Ranking of best states for gun owners}
  \item{hh.income}{Median household income (dollars)}
  \item{hispanic.percent}{Percentage of poulation Hispanic or Latino (of any race)}
  \item{hispanic.stateleg}{Percent of state legislators who are Hispanic/Latino}
  \item{hr.nominate.mean}{Mean NOMINATE score of state's House delegation}
  \item{hs.or.more}{Percentage of 25+ population attained at least high school diploma or equivalent}
  \item{hs.yrs.ss}{Years of social studies required to graduate high school}
  \item{infant.mortality}{Number of infant deaths per 1,000 live births}
  \item{judge.selection}{Method used to select appellate court judges}
  \item{judges.elected}{Does state elect appellate court judges?}
  \item{land.area}{Size of state in square miles}
  \item{legalclimate}{State legal climate rating 2015}
  \item{legalclimate.rank}{State legal climate ranking 2015}
  \item{legis.conservatism}{Rating of conservatism of state legislature}
  \item{legis.prof.rank}{State legislative professionalism rank for 2015}
  \item{legis.prof.score}{State legislative professionalism score for 2015}
  \item{lgbtq.equality.3cat}{Ordinal ranking of state policies for LQBTQ equality}
  \item{lgbtq.equality.laws}{Number of laws passed that advance LQBTQ equality}
  \item{median.age}{Median age (years)}
  \item{medicaid.expansion}{State action on Medicaid expansion pursuant to ACA}
  \item{min.wage}{State minimum wage}
  \item{obesity.percent}{Percentage of adults with a body mass index of 30.0 or higher}
  \item{opioid.rx.rate}{Retail opioid prescriptions dispensed per 100 persons}
  \item{over64}{Percentage of population 65 years and over}
  \item{polarization.house}{Polarization in State Legislatures, Lower chambers}
  \item{polarization.senate}{Polarization in State Legislatures, Upper chambers}
  \item{policy.innovation.rate}{Policy adoption rate score}
  \item{pop2016}{State population, 2016 (in 100k) }
  \item{pop.18.24}{Percentage of population 18 to 24 years old}
  \item{population}{State population in 2020}
  \item{population.change}{Percentage increase/decrease in population from 2010 to 2020}
  \item{pot.policy}{State marijuana laws in 2017}
  \item{poverty.rate}{Percentage of people in poverty}
  \item{prcapinc}{Per capita income}
  \item{preg.teen.rate}{Number of pregnancies per 1,000 women aged 15-19}
  \item{preg.uninten.rate}{Unintended pregnancy rate per 1,000 women 15-44}
  \item{prochoice.percent}{Percentage of adults who say abortion should be legal in all/most cases}
  \item{public.conservative}{Percentage adults self-identifying as conservative}
  \item{public.liberal}{Percentage adults self-identifying as liberal}
  \item{public.moderate}{Percentage adults self-identifying as moderate}
  \item{region}{Census region}
  \item{relig.Cath}{Percentage Catholic (2012)}
  \item{relig.Prot}{Percentage Protestant (2012)}
  \item{relig.high}{Percentage high religiosity (2012)}
  \item{relig.import}{Percent religion "A great deal of guidance"}
  \item{relig.import.2016}{Overall index of religiosity}
  \item{relig.low}{Percentage low religiosity (2012)}
  \item{religiosity}{Relig observance-belief scale (Pew)}
  \item{religiosity3}{Religiosity}
  \item{rtw}{Right to work state?}
  \item{schools.avg.salary}{Average salary of public school teachers}
  \item{schools.spend}{Expenditure per student in average daily attendance}
  \item{schools.st.ratio}{Students enrolled per teacher}
  \item{secularism}{Secularism scale (Pew)}
  \item{secularism3}{3 quantiles of secularism}
  \item{smokers}{Data_Value}
  \item{south}{Southern state?}
  \item{speak.english.only}{Percentage of population that only speaks English}
  \item{state}{State Name}
  \item{state.govt.rank}{Overall quality of state government administrative functions}
  \item{stateid}{Two-letter abbreviation of state name}
  \item{suicide.rate}{Number of deaths due to intentional self-harm per 100,000 population}
  \item{tax.source}{State's primary revenue source}
  \item{term.limits}{Does state have term limits for legislators?}
  \item{trump2016}{Vote share for Trump in 2016 election}
  \item{trump2016.ev}{Electoral College votes for Trump in 2016 election}
  \item{trump2020}{Two-party vote share for Trump in 2020 election}
  \item{trump2020.ev}{Electoral college votes for Trump in 2020 election}
  \item{turnout.20vs16}{Difference in voter turnout in 2020 compared to 2016}
  \item{under18}{Percentage of population under age 18}
  \item{unemployment}{State unemployment rate}
  \item{uninsured}{No health insurance coverage}
  \item{unionized}{Percent of workers who are union members}
  \item{unionized.4cat}{Ordinal-level measurement of state's percentage union membership}
  \item{urban}{Percent urban population}
  \item{vep16.turnout}{Percent turnout of voting eligible population in 2016}
  \item{vep18.turnout}{Percent turnout of voting eligible population in 2018}
  \item{vep20.turnout}{Percent turnout of voting eligible population in 2020}
  \item{volunteer.hrs.pc}{Volunteer hours per resident}
  \item{volunteer.rate}{Volunteer rate}
  \item{voter.id.law}{Voter identification law in effect in 2017}
  \item{white.percent}{Percentage of population white}
  \item{women.stateleg}{Percent of state legislators who are women}
}
}
\source{
Data sources vary.  See Appendix of printed textbook for further information.
}
\usage{
states
}
\description{
A dataset with variables about the 50 states. This dataset is used to demonstrate application of R to political analysis. See book Appendix for variable names and descriptions.
}
\keyword{datasets}
