% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{nes}
\alias{nes}
\title{NES dataset for R Companion to Political Analysis, Third Edition}
\format{
A data frame with 8280 rows and 429 variables.
\describe{
  \item{abortion.imp}{PRE: Importance of abortion issue to R}
  \item{abortion.legal}{PRE: STD Abortion: self-placement}
  \item{abortion.scotus}{PRE: SUMMARY: Abortion rights Supreme Court}
  \item{active.duty.mil}{PRE: Armed forces active duty}
  \item{address.yrs}{PRE: Years R lived at address}
  \item{age}{PRE: SUMMARY: Respondent age}
  \item{agree.facts}{PRE: How important that people agree on basic facts}
  \item{allow.refugees}{POST: SUMMARY: Favor/oppose allowing refugees to come to US}
  \item{american.id.import}{POST: How important is being American to R's identity}
  \item{angry.about.things}{PRE: How angry R feels about how things are going in the country}
  \item{approve.aca}{POST: SUMMARY: Approve/disapprove Affordable Care Act}
  \item{approve.cong}{PRE: SUMMARY: Approval of Congress handling its job}
  \item{approve.gov.covid}{PRE: SUMMARY: Approve or disapprove R's governor handling COVID-19}
  \item{approve.local.covid}{PRE: SUMMARY: Approve or disapprove local government handling COVID-19}
  \item{approve.pres.covid}{PRE: SUMMARY: Approve or disapprove President handling COVID-19}
  \item{approve.pres.econ}{PRE: SUMMARY: Approve or disapprove President handling economy}
  \item{approve.pres.hc}{PRE: SUMMARY: Approve or disapprove President handling health care}
  \item{approve.pres.imm}{PRE: SUMMARY: Approve or dissaprove President handling immigration}
  \item{approve.pres.ir}{PRE: SUMMARY: Approve or disapprove President handling foreign relations}
  \item{approve.pres.job}{PRE: SUMMARY: Approve or disapprove President handling job}
  \item{ban.assault.rif}{POST: SUMMARY: Favor/oppose banning 'assault-style' rifles}
  \item{been.arrested}{POST: Has R ever been arrested}
  \item{bible.god.man}{PRE: Is Bible word of God or men}
  \item{biden.cares}{PRE: Democratic Presidential candidate trait: really cares}
  \item{biden.honest}{PRE: Democratic Presidential candidate trait: honest}
  \item{biden.knowledge}{PRE: Democratic Presidential candidate trait: knowledgeable}
  \item{biden.libcon7}{PRE: 7pt scale liberal-conservative: Democratic Presidential candidate}
  \item{biden.strlead}{PRE: Democratic Presidential candidate trait: strong leadership}
  \item{birthright.citizens}{PRE: SUMMARY: Favor or oppose ending birthright citizenship}
  \item{blacks.gotless}{POST: Agree/disagree: blacks have gotten less than they deserve}
  \item{blacks.pastdiff}{POST: Agree/disagree: past slavery & discrimination make it difficult for blacks}
  \item{blacks.tryharder}{POST: Agree/disagree: if blacks tried harder they'd be as well off as whites}
  \item{blacks.workforit}{POST: Agree/disagree: blacks should work their way up without special favors}
  \item{border.wall}{PRE: SUMMARY: Favor or oppose building a wall on border with Mexico}
  \item{born.in.usa}{PRE: Rs: born US, Puerto Rico, or some other country}
  \item{buy.back.rifles}{POST: Favor/oppose government buy back of 'assault-style' rifles}
  \item{campaign.news.carlson}{PRE: Mention: TV PROG - Tucker Carlson Tonight (Fox)}
  \item{campaign.news.colbert}{PRE: Mention: TV PROG - The Late Show with Stephen Colbert}
  \item{campaign.news.hannity}{PRE: Mention: TV PROG - Hannity (Fox)}
  \item{campaign.news.maddow}{PRE: Mention: TV PROG - The Rachel Maddow Show (MSNBC)}
  \item{campaign.news.none}{PRE: Media sources R used to follow presidential campaign: none}
  \item{campaign.news.papers}{PRE: Media sources R used to follow presidential campaign: newspapers}
  \item{campaign.news.radio}{PRE: Media sources R used to follow presidential campaign: radio news}
  \item{campaign.news.tv}{PRE: Media sources R used to follow presidential campaign: tv programs}
  \item{campaign.news.web}{PRE: Media sources R used to follow presidential campaign: internet sites}
  \item{campaign.spendlim}{POST: Limits on campaign spending}
  \item{campaigns.interest}{PRE: How interested in following campaigns}
  \item{cant.get.ahead}{POST: Because of rich and powerful it's difficult for the rest to get ahead}
  \item{care.who.wins}{PRE: How much R cares who wins Presidential Election [revised]}
  \item{case.id}{2020 Case ID}
  \item{censor.self}{PRE: How often self censor}
  \item{changed.names}{PRE: R name ever changed}
  \item{child.behave}{POST: Which child trait more important: considerate or well-behaved}
  \item{child.manners}{POST: Which child trait more important: curiosity or good manners}
  \item{child.obey}{POST: Which child trait more important: obedience or self-reliance}
  \item{child.respect}{POST: Which child trait more important: independence or respect}
  \item{citizenship.path}{POST: SUMMARY: Favor/oppose providing path to citizeship}
  \item{civ12.argue}{POST: Has R in past 12 months: gotten into a political argument}
  \item{civ12.comment}{POST: Has R in past 12 months: posted comment online about political issue}
  \item{civ12.community}{POST: Has R in past 12 months: worked w/others to deal w/issue facing community}
  \item{civ12.cong}{POST: Has R in past 12 months: contacted member of US Senate or House of Rep}
  \item{civ12.fedoff}{POST: Has R in past 12 months: contacted non-elected official in federal govt}
  \item{civ12.fedpol}{POST: Has R in past 12 months: contacted federal elected official}
  \item{civ12.giveorg}{POST: Has R in past 12 months: given money to other organization}
  \item{civ12.giverelig}{POST: Has R in past 12 months: given money to religious organization}
  \item{civ12.march}{POST: Has R in past 12 months: joined a protest march, rally, or demonstration}
  \item{civ12.meeting}{POST: Has R in past 12 months: attend mtg about issue facing community/schools}
  \item{civ12.petition}{POST: Has R in past 12 months: sign internet or paper petition}
  \item{civ12.stateoff}{POST: Has R in past 12 months: contacted non-elected official in state/local gov}
  \item{civ12.statepol}{POST: Has R in past 12 months: contacted elected official on state/local level}
  \item{civ12.vol}{POST: Has R in past 12 months: done any volunteer work}
  \item{climate.ch.weather}{POST: How much is climate change affecting severe weather/temperatures in US}
  \item{climate.import}{POST: How important is issue of climate change to R}
  \item{community.yrs}{PRE: How long lived in this community YRS}
  \item{consumer.politics}{POST: How often bought or boycotted product/service for social/political reasons}
  \item{contacted.gotv}{POST: Anyone talk to R about registering or getting out to vote}
  \item{covid.election}{PRE: Options for election if COVID-19 continues}
  \item{covid.fed}{PRE: SUMMARY: Federal government response to COVID-19}
  \item{covid.made.lab}{POST: Was the coronavirus (COVID-19) was developed intentionally in a lab or not}
  \item{covid.reopening}{PRE: SUMMARY: Re-opening too quickly or too slowly}
  \item{covid.restrictions}{PRE: Limits placed on public activity due to COVID-19 too strict or not}
  \item{covid.science.help}{POST: How important should science be for decisions about COVID-19}
  \item{death.penalty}{PRE: SUMMARY: R favor/oppose death penalty}
  \item{def.spend.7pt}{PRE: 7pt scale defense spending: self-placement}
  \item{deficit.reduce}{POST: Importance of reducing deficit}
  \item{dem.libcon7}{PRE: 7pt scale liberal-conservative: Democratic party}
  \item{deport.children}{PRE: SUMMARY: Should children brought illegally be sent back or allowed to stay}
  \item{deport.unauth}{POST: SUMMARY: Favor/oppose returning unauthorize immigrants to native country}
  \item{discrim.vs.asians}{POST: Discrimination in the US against Asians}
  \item{discrim.vs.blacks}{POST: Discrimination in the US against blacks}
  \item{discrim.vs.christians}{POST: Discrimination in the US against Christians}
  \item{discrim.vs.glb}{POST: Discrimination in the US against Gays and Lesbians}
  \item{discrim.vs.hispanics}{POST: Discrimination in the US against Hispanics}
  \item{discrim.vs.men}{POST: Discrimination in the US against men}
  \item{discrim.vs.muslims}{POST: Discrimination in the US against Muslims}
  \item{discrim.vs.trans}{POST: Discrimination in the US against transgender people}
  \item{discrim.vs.whites}{POST: Discrimination in the US against whites}
  \item{discrim.vs.women}{POST: Discrimination in the US against women}
  \item{diversity.good.usa}{POST: SUMMARY: Increasing diversity made US better/worse place to live}
  \item{divided.govt}{PRE: Party Control or split government}
  \item{donations.change.votes}{POST: Congress change votes because of donation to campaign}
  \item{econ.current}{PRE: Current economy good or bad}
  \item{econ.lastyear}{PRE: SUMMARY: National economy better or worse in last year}
  \item{econ.mobility.now}{POST: SUMMARY: Economic mobility}
  \item{econ.nextyear}{PRE: SUMMARY: Economy better or worse in next 12 months}
  \item{econ.worry}{PRE: How worried about national economy}
  \item{educ.5cat}{PRE: SUMMARY: Respondent 5 Category level of education}
  \item{education}{PRE: Highest level of Education}
  \item{elect.asians}{POST: How important that more Asians get elected to political office}
  \item{elect.blacks}{POST: How important that more blacks get elected to political office}
  \item{elect.hispanics}{POST: How important that more Hispanics get elected to political office}
  \item{elect.lgbt}{POST: How important that more LGBT people get elected to political office}
  \item{elect.women}{POST: How important that more women get elected to political office}
  \item{elections.govt.attn}{PRE: Elections make government pay attention}
  \item{envir.or.biz}{PRE: 7pt scale environment-business tradeoff: self-placement}
  \item{equal.opp}{POST: Society should make sure everyone has equal opportunity}
  \item{facebook.polpost}{POST: How often post political content on Facebook}
  \item{facebook.use}{POST: How often use Facebook}
  \item{faced.gender.discrim}{POST: How much discrimination has R faced because of gender}
  \item{faced.race.discrim}{POST: How much discrimination has R faced personally because or race/ethnicity}
  \item{fed.bw.better}{POST: SUMMARY: Federal government treats blacks or whites better}
  \item{fedspend.aidpoor}{PRE: SUMMARY: Federal Budget Spending: aid to the poor}
  \item{fedspend.border}{PRE: SUMMARY: Federal Budget Spending: Tightening border security}
  \item{fedspend.crime}{PRE: SUMMARY: Federal Budget Spending: dealing with crime}
  \item{fedspend.environ}{PRE: SUMMARY: Federal Budget Spending: protecting the environment}
  \item{fedspend.highways}{PRE: SUMMARY: Federal Budget Spending: building and repairing highways}
  \item{fedspend.schools}{PRE: SUMMARY: Federal Budget Spending: public schools}
  \item{fedspend.socsec}{PRE: SUMMARY: Federal Budget Spending: Social Security}
  \item{fedspend.welfare}{PRE: SUMMARY: Federal Budget Spending: welfare programs}
  \item{feminist}{POST: Does R consider themself a feminist or anti-feminist}
  \item{feminist.import}{POST: How important is being a feminist}
  \item{finance.lastyear}{PRE: R how much better or worse off financially than 1 year ago}
  \item{finance.nextyear}{PRE: R how much better or worse off financially next year}
  \item{financial.worried}{PRE: How worried is R about current financial situation}
  \item{ft.asian.am}{POST: Feeling thermometer: Asian-Americans}
  \item{ft.asians}{POST: Feeling thermometer: Asians}
  \item{ft.biden.post}{POST: Feeling thermometer: Democratic Presidential candidate: Joe Biden}
  \item{ft.biden.pre}{PRE: Feeling Thermometer: Joe Biden, Democratic Presidential candidate}
  \item{ft.bigbiz}{POST: Feeling thermometer: big business}
  \item{ft.blacks}{POST: Feeling thermometer: blacks}
  \item{ft.blm}{POST: Feeling thermometer: Black Lives Matter}
  \item{ft.capitalists}{POST: Feeling thermometer: capitalists}
  \item{ft.cdc}{POST: Feeling thermometer: Center for Disease Control (CDC)}
  \item{ft.christian.fund}{POST: Feeling thermometer: Christian fundamentalists}
  \item{ft.christians}{POST: Feeling thermometer: Christians}
  \item{ft.congress}{POST: Feeling thermometer: congress}
  \item{ft.conservatives}{POST: Feeling thermometer: conservatives}
  \item{ft.dem}{PRE: Feeling Thermometer: Democratic Party}
  \item{ft.fauci}{POST: Feeling thermometer: Dr. Anthony Fauci}
  \item{ft.fbi}{POST: Feeling thermometer: Federal Bureau of Investigation (FBI)}
  \item{ft.feminists}{POST: Feeling thermometer: feminists}
  \item{ft.gays.lesbians}{POST: Feeling thermometer: gay men and lesbians}
  \item{ft.harris.post}{POST: Feeling thermometer: Democratic Vice Presidential candidate: Kamala Harris}
  \item{ft.harris.pre}{PRE: Feeling Thermometer: Kamala Harris, Democratic Vice-Presidential candidate}
  \item{ft.hispanics}{POST: Feeling thermometer: Hispanics}
  \item{ft.ice}{POST: Feeling thermometer: Immigration and Customs Enforcement (ICE) agency}
  \item{ft.illegal.imm}{POST: Feeling thermometer: illegal immigrants}
  \item{ft.jews}{POST: Feeling thermometer: Jews}
  \item{ft.journalists}{POST: Feeling thermometer: journalists}
  \item{ft.liberals}{POST: Feeling thermometer: liberals}
  \item{ft.metoo}{POST: Feeling thermometer: #MeToo movement}
  \item{ft.muslims}{POST: Feeling thermometer: Muslims}
  \item{ft.nato}{POST: Feeling thermometer: North Atlantic Treaty Organization (NATO)}
  \item{ft.nra}{POST: Feeling thermometer: National Rifle Association (NRA)}
  \item{ft.obama}{PRE: Feeling Thermometer: Barack Obama}
  \item{ft.pence.post}{POST: Feeling thermometer: Republican Vice Presidential candidate: Mike Pence}
  \item{ft.pence.pre}{PRE: Feeling Thermometer: Mike Pence, Republican Vice-Presidential candidate}
  \item{ft.police}{POST: Feeling thermometer: police}
  \item{ft.pp}{POST: Feeling thermometer: Planned Parenthood}
  \item{ft.rep}{PRE: Feeling Thermometer: Republican Party}
  \item{ft.rural}{POST: Feeling thermometer: rural Americans}
  \item{ft.scientists}{POST: Feeling thermometer: scientists}
  \item{ft.scotus}{POST: Feeling thermometer: U.S. Supreme Court}
  \item{ft.socialists}{POST: Feeling thermometer: socialists}
  \item{ft.transgender}{POST: Feeling thermometer: transgender people}
  \item{ft.trump.post}{POST: Feeling thermometer: Republican Presidential candidate: Donald Trump}
  \item{ft.trump.pre}{PRE: Feeling Thermometer: Donald Trump, Republican Presidential candidate}
  \item{ft.un}{POST: Feeling thermometer: United Nations (UN)}
  \item{ft.unions}{POST: Feeling thermometer: labor unions}
  \item{ft.whites}{POST: Feeling thermometer: whites}
  \item{ft.who}{POST: Feeling thermometer: World Health Organization (WHO)}
  \item{gay.adopt}{PRE: Should gay and lesbian couples be allowed to adopt}
  \item{gay.job.discrim}{PRE: SUMMARY: Favor/oppose laws protect gays lesbians against job discrimination}
  \item{gay.marriage}{PRE: R position on gay marriage}
  \item{gay.req.service}{PRE: SUMMARY: Services to same sex couples}
  \item{gender}{PRE: What is your (R) sex? [revised]}
  \item{gov.asst.blacks}{PRE: 7pt scale gov assistance to blacks scale: self-placement}
  \item{govt.act.ineq}{POST: SUMMARY: Favor/oppose government trying to reduce income inequality}
  \item{govt.act.warm.str}{PRE: Government action about rising temperatures (STRENGTH)}
  \item{govt.act.warming}{PRE: Government action about rising temperatures}
  \item{govt.corrupt}{PRE: How many in government are corrupt}
  \item{govt.guar.job}{PRE: 7pt scale guaranteed job-income scale: self-placement}
  \item{govt.hc.7pt}{PRE: 7pt scale gov-private medical insurance scale: self-placement}
  \item{govt.help.hc}{POST: SUMMARY: Increase/decrease government spending to help pay for health care}
  \item{govt.run.byfew}{PRE: Government run by a few big interests or for benefit of all}
  \item{govt.services.7pt}{PRE: 7pt scale spending & services: self-placement}
  \item{govt.under.media}{PRE: How concerned government might undermine media}
  \item{govt.wastes.money}{PRE: Does government waste much tax money}
  \item{govtreg.moreless}{POST: Would it be good for society to have more or less government regulation}
  \item{grand.born.usa}{PRE: How many grandparents born outside the US}
  \item{grew.up.where}{PRE: Where R grew up}
  \item{gun.bg.checks}{POST: SUMMARY: Favor/oppose background checks for gun puchases}
  \item{gun.buying}{POST: Should federal government make it more difficult or easier to buy a gun}
  \item{gun.issue.imp}{POST: How important is issue of gun access to R}
  \item{guns.owned}{PRE: How many Guns owned}
  \item{happy.about.things}{PRE: How happy R feels about how things are going in the country}
  \item{hardvote2020}{POST: How difficult was it for R to vote}
  \item{harrassed.work}{POST: Has R experienced harrassment at work}
  \item{harrassed.work.oft}{POST: How often has R experienced harrassment at work}
  \item{has.daughter}{POST: Does R have any sons or daughters - one or more daughters}
  \item{has.nokids}{POST: Does R have any sons or daughters - no sons and no daughters}
  \item{has.son}{POST: Does R have any sons or daughters - one or more sons}
  \item{have.health.ins}{PRE: Does R have health insurance}
  \item{hc.pay.bills}{PRE: How likely R able to pay all health care costs in next 12 months}
  \item{health}{PRE: Health of R}
  \item{health.lose.ins}{PRE: R concerned about losing health insurance}
  \item{health.pay.costs}{PRE: R concerned about paying for health care}
  \item{help.with.science}{POST: How much do people need help from experts to understand science}
  \item{hh.covid.symp}{PRE: Anyone in household COVID-19 based on symptoms}
  \item{hh.covid.test}{PRE: Anyone in household tested pos for COVID-19}
  \item{hh.family.mem}{PRE: R living with how many family members}
  \item{hh.income}{PRE-POST: SUMMARY: Total (family) income}
  \item{hh.income.pre}{PRE: SUMMARY: Total (family) income}
  \item{hh.landline}{PRE: Is there a working HH landline phone}
  \item{hh.num.child}{PRE: How many children in HH age 0-17}
  \item{hh.partner.status}{PRE: Domestic partnership status}
  \item{hh.union.mem}{PRE: Anyone in HH belong to labor union}
  \item{housing.payments}{PRE: How likely R able to make all housing payments in next 12 months}
  \item{hydrox.treat.covid}{POST: Evidence that hydroxychloroquine is effective treatment for COVID-19 or no}
  \item{immig.crime}{POST: SUMMARY: effect of illegal immiration on crime rate}
  \item{immig.levels}{POST: What should immigration levels be}
  \item{immig.policy}{PRE: US government policy toward unauthorized immigrants}
  \item{immig.take.jobs}{POST: How likely immigration will take away jobs}
  \item{imp.govt.checks}{PRE: How important branches of government keep one another from too much power}
  \item{imp.media.crit}{PRE: How important that news organizations free to criticize}
  \item{imp.off.conseq}{PRE: How important elected officials face serious consequences for misconduct}
  \item{imports.limit}{POST: SUMMARY: Favor/oppose new limits on imports}
  \item{income.gap.change}{PRE: SUMMARY: How much larger is income gap today}
  \item{income.gap.today}{PRE: Income gap today more or less than 20 years ago}
  \item{ineq.worryless}{POST: We'd be better off if worried less about equality}
  \item{intl.force}{PRE: Force to solve international problems}
  \item{invest.stocks}{PRE: Money invested in Stock Market}
  \item{laws.contrib.indiv}{POST: Congress pass laws that benefit contributor individuals}
  \item{laws.contrib.org}{POST: Congress pass laws that benefit contributor organization}
  \item{leader.compromise}{PRE: Prefer government official who compromises or sticks to principles}
  \item{libcon3}{PRE: 3pt scale liberal-conservative self-placement}
  \item{libcon7}{PRE: 7pt scale liberal-conservative self-placement}
  \item{life.sat}{PRE: How satisfied is R with life}
  \item{lifex.buyusa}{POST: Life experience: does R choose products because they are made in America}
  \item{lifex.flyflag}{POST: Life experience: has R displayed American flag on house in past year}
  \item{lifex.foodstamps}{POST: Life experience: has R ever received food stamps or other public assistanc}
  \item{lifex.huntfish}{POST: Life experience: has R gone hunting or fishing in past year}
  \item{lifex.knowimmig}{POST: Life experience: does R know someone moved to U.S. from another country}
  \item{lifex.oweloans}{POST: Life experience: does R currently owe money on student loans}
  \item{lifex.retireacct}{POST: Life experience: does R a have pension or retirement account}
  \item{lifex.ridebus}{POST: Life experience: has R used public transportation in past year}
  \item{lifex.sharkbite}{POST: Life experience: has R ever been bitten by a shark}
  \item{lqb.friendfam}{POST: R has family/neighbors/coworkers/friends who are gay, lesbian or bisexual}
  \item{marital}{PRE: Marital status}
  \item{medical.putoff}{PRE: Put off checkup and vaccines}
  \item{metoo.toofar}{POST: SUMMARY: Attention to sexual harrassment as gone too far/not far enough}
  \item{middle.class.ext}{POST: Is R lower middle class, middle class, upper middle class? [EGSS]}
  \item{min.wage.change}{POST: Should the minimum wage be raised, kept the same, or lowered}
  \item{morals.adjust}{POST: The world is changing & we should adjust view of moral behavior}
  \item{morechance.okay}{POST: Not a big problem if some have more chance in life}
  \item{moreless.govt}{POST:SUMMARY: Less or more government}
  \item{opioid.addiction}{POST: SUMMARY Should federal govt do more/less about opioid drug addiction}
  \item{oth.race.concern}{POST: How often does R have concerned feelings for other racial/ethnic groups}
  \item{oth.race.feel}{POST: How often R imagines how they would feel before criticizing other groups}
  \item{oth.race.persp}{POST: How often does R try to understand perpective of other racial/ethnic group}
  \item{oth.race.protect}{POST: How often R feels protective of someone due to race or ethnicity}
  \item{paid.parent.leave}{PRE: SUMMARY: Require employers to offer paid leave to parents of new children}
  \item{parents.born.usa}{PRE: Native status of parents}
  \item{party.register}{PRE-POST: SUMMARY: Party of registration}
  \item{partyid3}{PRE: Party ID, 3 categories}
  \item{partyid7}{PRE: SUMMARY: Party ID}
  \item{partyid.importance}{PRE: Party identity importance}
  \item{people.fed.lies}{POST: Much of what people hear in schools and media are lies by those in power}
  \item{people.too.sens}{PRE: Need to be more sensitive talking or people too easily offended}
  \item{person.get.ahead}{POST: How much opportunity in America for average person to get ahead}
  \item{pol.asian.infl}{POST: How much influence do Asians have in US politics}
  \item{pol.black.infl}{POST: How much influence do blacks have in US politics}
  \item{pol.dontcare}{POST: [STD] Public officials don't care what people think}
  \item{pol.for.insiders}{POST: Our political system only works for insiders with money and power}
  \item{pol.hispanic.infl}{POST: How much influence do Hispanics have in US politics}
  \item{pol.hurt.fam}{POST: How much have political differences hurt relationships w/family}
  \item{pol.nosay}{POST: [STD] Have no say about what goverment does}
  \item{pol.oligarchy}{POST: Business and politics controlled by few powerful people}
  \item{pol.toocomplex}{POST: [REV] Politics/government too complicated to understand}
  \item{pol.understand}{POST: [REV] How well does R understand important political issues}
  \item{pol.white.infl}{POST: How much influence do whites have in US politics}
  \item{polact.givecand}{POST: R contribute money to individual candidate running for public office}
  \item{polact.giveoth}{POST: R contribute to any other group that supported or opposed candidates}
  \item{polact.giveparty}{POST: R contribute money to political party during this election year}
  \item{polact.meetings}{POST: R go to any political meetings, rallies, speeches, dinners}
  \item{polact.onlinemeet}{POST: R attend online political meetings, rallies, speeches, fundraisers}
  \item{polact.othwork}{POST: R do any (other) work for party or candidate}
  \item{polact.postsign}{POST: R wear campaign button or post sign or bumper sticker}
  \item{polact.talkpol}{POST: R ever discuss politics with family or friends}
  \item{polact.talkvote}{POST: R talk to anyone about voting for or against a party or candidate}
  \item{police.bw.better}{POST: SUMMARY: Police treat blacks or whites better}
  \item{police.stop.lastyr}{POST: During past 12 months, R  or any family members stopped by police}
  \item{police.useforce}{POST: How often do police officers use more force than necessary}
  \item{political.violence}{PRE: SUMMARY: Political violence compared to 4 yrs ago}
  \item{politics.attention}{PRE: How often does R pay attention to politics and elections}
  \item{polquiz.fedspend}{PRE: On which program does Federal government spend the least}
  \item{polquiz.german}{POST: Office recall: German Chancellor - Angela Merkel [coded/scheme 1]}
  \item{polquiz.housemaj}{PRE: Party with most members in House before election}
  \item{polquiz.russian}{POST: Office recall: Russian President - Vladimir Putin [coded/scheme 1]}
  \item{polquiz.scotus}{POST: Office recall: SCOTUS Chief Justice - John Roberts [coded/scheme 1]}
  \item{polquiz.sen.term}{PRE: How many years in full term for US Senator}
  \item{polquiz.senatemaj}{PRE: Party with most members in Senate before election}
  \item{polquiz.speaker}{POST: Office recall: Speaker of the House - Nancy Pelosi [coded/scheme 1]}
  \item{polquiz.vp}{POST: Office recall: Vice-President - Mike Pence [coded]}
  \item{postmat.1a}{POST: Post materialism most important 1A}
  \item{postmat.1b}{POST: Post materialism next most important 1B}
  \item{postmat.2a}{POST: Post materialism most important 2A}
  \item{postmat.2b}{POST: Post materialism next most important 2B}
  \item{pref.hiring.blacks}{POST: SUMMARY: Favor/oppose preferential hiring/promotion of blacks}
  \item{pres.ask.foreign}{PRE: Appropriate/inappropriate Pres ask foreign countries to investigate rivals}
  \item{pres.nochecks}{PRE: SUMMARY: Helpful/harmful if Pres didn't have to worry about congress/courts}
  \item{presvote2020}{PRE-POST: SUMMARY: 2020 Presidential vote}
  \item{primary.voter}{PRE: Did R vote in a Presidential primary or caucus}
  \item{protestors.conduct}{PRE: SUMMARY: Protestors actions been mostly violent or peaceful}
  \item{race.ethnicity}{PRE: SUMMARY: R self-identified race/ethnicity}
  \item{reddit.polpost}{POST: How often post political content on Reddit}
  \item{reddit.use}{POST: How often use Reddit}
  \item{reg.greenhouse}{POST: SUMMARY: Favor/oppose increased regulation on greenhouse emissions}
  \item{region}{SAMPLE: Census region}
  \item{relig.ever.attend}{PRE: Ever attend church or religious services}
  \item{relig.how.often}{PRE: Attend religious services how often}
  \item{religion}{PRE: What is present religion of R}
  \item{religion.group}{PRE: SUMMARY: Major group religion summary}
  \item{religion.imp}{PRE: Is religion important part of R life [revised]}
  \item{religious.id}{PRE: Religious identification}
  \item{rep.libcon7}{PRE: 7pt scale liberal-conservative: Republican party}
  \item{restrict.journalists}{PRE: SUMMARY: Favor or oppose restricting journalist access}
  \item{rural.getmore}{POST: SUMMARY: People in rural areas get more/less from government}
  \item{rural.influence}{POST: SUMMARY: People in rural areas have too much/too little influence}
  \item{rural.respect}{POST: SUMMARY: People in rural areas get too much/too little respect}
  \item{rural.urban}{POST: Does R currently live in a rural or urban area}
  \item{rural.urban.id}{POST: How important is urban or rural to R's identity}
  \item{russia.int.election}{PRE: Likelihood of Russian interference in upcoming election}
  \item{russia.interfere}{POST: Did Russia try to interfere in 2016 presidential election or not}
  \item{separate.children}{POST: SUMMARY: Favor/oppose separating children of detained immigrants}
  \item{sexual.orient}{PRE: Sexual orientation of R [revised]}
  \item{smoke.cig.life}{POST: R smoked 100 cigarettes in life}
  \item{smoke.cig.now}{POST: R currently smoking}
  \item{social.class}{POST: How would R describe social class [EGSS]}
  \item{speak.english}{PRE: How important to speak English in US}
  \item{split.ticket}{PRE: Split-ticket voting}
  \item{state}{SAMPLE: Sample location FIPS state}
  \item{stateabbr}{SAMPLE: Sample location state postal abbreviation}
  \item{survey.serious}{PRE: How often took survey seriously}
  \item{talkpol.week}{POST: How many days in past week discussed politics with family or friends}
  \item{tax.rich}{POST: Favor or oppose tax on millionaires}
  \item{terrorism.worry}{POST: DHS: How worried about terrorist attack in near future}
  \item{threat.from.china}{POST: How much is China a threat to the United States}
  \item{threat.from.germany}{POST: How much is Germany a threat to the United States}
  \item{threat.from.iran}{POST: How much is Iran a threat to the United States}
  \item{threat.from.japan}{POST: How much is Japan a threat to the United States}
  \item{threat.from.mexico}{POST: How much is Mexico a threat to the United States}
  \item{threat.from.russia}{POST: How much is Russia a threat to the United States}
  \item{trad.fam.values}{POST: Fewer problems if there was more emphasis on traditional family values}
  \item{trade.agreements}{POST: SUMMARY: Favor/oppose free trade agreements}
  \item{trade.good.ir}{POST: SUMMARY: Increasing trade good/bad for international relationships}
  \item{trade.jobs.abroad}{POST: SUMMARY: International trade increaded/decreased jobs abroad}
  \item{trade.jobs.usa}{POST: SUMMARY: International trade increased/decreased jobs in US}
  \item{trans.friendfam}{POST: R has family/neighbors/coworkers/friends who are transgender}
  \item{trans.military}{POST: SUMMARY: Favor/oppose transender people serve in military}
  \item{trans.policy}{PRE: SUMMARY: Transgender policy}
  \item{treat.people.fair}{POST: If people were treated more fairly we would have fewer problems}
  \item{trump.acquittal}{PRE: SUMMARY: Favor or oppose Senate acquittal decision}
  \item{trump.cares}{PRE: Republican Presidential Candidate trait: really cares}
  \item{trump.corruption}{PRE: SUMMARY: Corruption increased or decreased since Trump}
  \item{trump.deport.more}{POST: Did Trump administration deport more immigrants or did Obama}
  \item{trump.honest}{PRE: Republican Presidential Candidate trait: honest}
  \item{trump.impeachment}{PRE: SUMMARY: Favor or oppose House impeachment decision}
  \item{trump.knowledge}{PRE: Republican Presidential Candidate trait: knowledgeable}
  \item{trump.libcon7}{PRE: 7pt scale liberal-conservative: Republican Presidential candidate}
  \item{trump.strlead}{PRE: Republican Presidential Candidate trait: strong leadership}
  \item{trump.ukraine}{PRE: Did Trump ask Ukraine to investigate rivals}
  \item{trust.dc}{PRE: How often trust government in Washington to do what is right [revised]}
  \item{trust.election.off}{PRE: Trust election officials}
  \item{trust.experts}{POST: SUMMARY: Trust ordinary people/experts for public policy}
  \item{trust.media}{PRE: How much trust in news media}
  \item{trust.people}{PRE: How often can people be trusted}
  \item{turnout2020}{PRE-POST: SUMMARY: Voter turnout in 2020}
  \item{twitter.polpost}{POST: How often post political content on Twitter}
  \item{twitter.use}{POST: How often use Twitter}
  \item{unemploy.lastyear}{PRE: SUMMARY: Unemployment better or worse in last year}
  \item{unemploy.nextyear}{PRE: More or less unemployment in next year}
  \item{unemploy.rate.now}{POST: What is the current unemployment rate}
  \item{univ.basic.income}{POST: SUMMARY: Favor/oppose federal program giving citizens $12K/year}
  \item{urban.unrest}{PRE: Best way to deal with urban unrest}
  \item{usa.better}{POST: SUMMARY: US better or wose than most other countries}
  \item{usa.on.track}{PRE: Are things in the country on right track}
  \item{usa.stay.home}{PRE: SUMMARY: Country would be better off if we just stayed home}
  \item{usa.stronger}{PRE: During last year, US position in world weaker or stronger}
  \item{vaccine.schools}{POST: SUMMARY: Favor/oppose requiring vaccines in schools}
  \item{vaccines.autism}{POST: Does most scientific evidence show vaccines cause autism or not}
  \item{vaccines.risk}{POST: SUMMARY: Health benefits of vaccinations outweigh risks}
  \item{violence.justified}{PRE: Justified to use violence}
  \item{vote.pres.str}{POST: Preference strong for Presidential candidate for whom R vote}
  \item{vote.when.decide}{POST: How long before election R made decision Presidential vote [coded]}
  \item{votes.accurate}{PRE: Votes counted accurately}
  \item{votes.faircount}{POST: How often are votes counted fairly}
  \item{voting.duty.choice}{PRE: SUMMARY: Voting as duty or choice}
  \item{voting.felons}{PRE: SUMMARY: Favor/oppose allowing felons to vote}
  \item{voting.id}{PRE: SUMMARY: Favor/oppose requiring ID when voting}
  \item{voting.mail}{PRE: SUMMARY: Favor/oppose vote by mail}
  \item{voting.rts.denied}{PRE: How often people denied right to vote}
  \item{waitvote2020}{POST: How long was wait time at polling place}
  \item{whenvote2020}{POST: When R voted in 2020 election}
  \item{whites.revdiscrim}{POST: How likely whites unable to find jobs because employers hiring minorities}
  \item{wom.complain.prob}{POST: Do women complaining about discrimination cause more problems}
  \item{wom.control.men}{PRE: Women seek to gain power by getting control over men}
  \item{wom.equal.spfav}{POST: Do women demanding equality seek special favors}
  \item{wom.interp.sexist}{PRE: Women interpret innocent remarks as sexist}
  \item{women.stay.honme}{POST: SUMMARY: Better/worse if man works and woman takes care of home}
  \item{work.employer}{PRE: Describe R's employment}
  \item{work.hoursweek}{PRE: How many hours R worked per week}
  \item{work.lastweek}{PRE: R worked for pay last week}
  \item{work.mom.bond}{POST: SUMMARY: Easier/harder for working mother to bond with child}
  \item{work.status}{PRE: SUMMARY: R occupation status 1 digit}
  \item{world.like.usa}{POST: Better if rest of world more like America}
  \item{world.temp.rising}{POST: Have world temperatuers have risen on average or last 100 years or not}
  \item{wt}{Full sample pre-election weight}
  \item{wt.post}{Full sample post-election weight} 
}
}
\source{
2020 American National Election Survey.  See Appendix of printed textbook for further information
}
\usage{
nes
}
\description{
The American National Election Survey polls individuals about their political beliefs and behavior. This dataset is used to demonstrate application of R to political analysis. See book Appendix for variable names and descriptions.
}
\keyword{datasets}
