% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{add_pic}
\alias{add_pic}
\title{Fills in df_pic: adds a row with the calculated PIC for the current configuration.}
\usage{
add_pic(
  df,
  index_configuration,
  robust,
  Y,
  beta_est,
  g,
  S,
  k,
  kg,
  pic_e2,
  C_candidates,
  method_estimate_beta = "individual",
  choice_pic = "pic2022"
)
}
\arguments{
\item{df}{input data frame}

\item{index_configuration}{index of the configuration of groups and factors}

\item{robust}{robust or classical estimation}

\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{beta_est}{estimated values of beta}

\item{g}{vector with estimated group membership for all individuals}

\item{S}{number of estimated groups}

\item{k}{estimated number of common factors}

\item{kg}{vector with the estimated number of group specific factors for each group}

\item{pic_e2}{NxT matrix with the error terms}

\item{C_candidates}{candidates for C (parameter in PIC)}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{choice_pic}{parameter that defines which PIC is used to select the best configuration of groups and factors.
Options are "pic2017" (uses the PIC of \insertCite{Ando2017;textual}{RCTS}),
"pic2016" (\insertCite{Ando2016;textual}{RCTS}) weighs the fourth term with an extra factor relative to the size of the groups, and "pic2022".
They differ in the penalty they perform on the number of group specific factors (and implicitly on the number of groups). They also differ in the sense that they have
different NT-regions (where N is the number of time series and T is the length of the time series) where the estimated number of groups, and thus group specific factors will be wrong.
Pic2022 is the default (this PIC shrinks the problematic NT-region to very large N / very small T).}
}
\value{
data.frame
}
\description{
Fills in df_pic: adds a row with the calculated PIC for the current configuration.
}
\examples{
set.seed(1)
original_data <- create_data_dgp2(30, 10)
Y <- original_data[[1]]
g <- original_data[[3]]
beta_est <- matrix(rnorm(4 * nrow(Y)), nrow = 4)
df_pic <- initialise_df_pic(1:5)
e <- matrix(rnorm(nrow(Y) * ncol(Y)), nrow(Y))
add_pic(df_pic, 1, TRUE, Y, beta_est, g, 3, 0, c(3, 3, 3), e, 1:5)
}
