% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{headst}
\alias{headst}
\title{Head Start data from Ludwig and Miller (2007)}
\format{
A data frame with 3,127 rows and 18 variables:

\describe{
\item{statefp}{State FIPS code}
\item{countyfp}{County FIPS code}
\item{oldcode}{ID in Ludwig-Miller dataset}
\item{povrate}{Poverty rate in 1960 relative to 300th poorest county (which
     had poverty rate 59.1984)}
\item{mortHS}{Average Mortality rate per 100,000 for children aged 5-9 over
1973--83 due to causes addressed as part of Head Start's health services}

\item{mortInj}{Average Mortality rate per 100,000 for children aged 5-9 over
1973--83 due to injury}
\item{hs90}{High school completion rate in 1990 census, ages 18-24}
\item{pop}{County population (1960 census)}
\item{sch1417}{Percent attending school, ages 14-17 (1960 census)}
\item{sch534}{Percent attending school, ages 5-34 (1960 census)}
\item{hs60}{High school completion rate in 1960 census, ages 25+}
\item{pop1417}{Population aged 14-17 (1960 census)}
\item{pop534}{Population aged 5-34 (1960 census)}
\item{pop25}{Population aged 25+ (1960 census)}
\item{urban}{Percent urban (1960 census)}
\item{black}{Percent black (1960 census)}
\item{statepc}{State postal code}
\item{county}{County name}
}
}
\source{
Douglas Miller's former website,
\url{http://web.archive.org/web/20190619165949/http://faculty.econ.ucdavis.edu:80/faculty/dlmiller/statafiles/}
}
\usage{
headst
}
\description{
Subset of Ludwig-Miller (2007) data. Counties with missing poverty rate, or
with both outcomes missing (\code{hs} and \code{mortality}) were removed. In
the original dataset, Yellowstone County, MT (\code{oldcode = 27056}) was
entered twice, here the duplicate is removed. Yellowstone National Park, MT
(\code{oldcode = 27057}) is also removed due to it being an outlier for both
outcomes. Counties with \code{oldcode} equal to (3014, 32032, 47010, 47040,
47074, 47074, 47078, 47079, 47096) matched more than one FIPS entry, so the
county labels may not be correct. Mortality data is missing for Alaska.
}
\references{
{

\cite{Jens Ludwig and Douglas L. Miller. Does head start improve children's
      life chances? Evidence from a regression discontinuity design.
      Quarterly Journal of Economics, 122(1):159–208, February 2007.
      \doi{10.1162/qjec.122.1.159}}

}
}
\keyword{datasets}
