% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_queries.R
\name{check_queries}
\alias{check_queries}
\title{Check modifications between two dataset of queries}
\usage{
check_queries(old, new)
}
\arguments{
\item{old}{Old version of the dataset of queries.}

\item{new}{New version of the dataset of queries. This object will be used to determine the status of each query.}
}
\value{
A list contaning a data frame with a merge of all queries plus a column indicating which queries were resolved or are new comparing to the old queries dataset and the total of queries per category of the added column.
}
\description{
This function compares a former dataset of queries with a new one and allows you to check which of the old queries were resolved, which are yet to be resolved and which of them are new.
}
\examples{
data_old <- rd_query(variables = "copd",
                     expression = "\%in\%NA",
                     event = "initial_visit_arm_1",
                     dic = covican$dictionary,
                     data = covican$data)
data_new <- rbind(data_old$queries[1:5,], c("100-20",rep("abc",8)))

# Control of queries
check <- check_queries(old = data_old$queries,
                       new = data_new)
}
