% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REDCapR-package.R
\docType{package}
\name{REDCapR-package}
\alias{REDCapR}
\alias{REDCapR-package}
\title{REDCapR: Interaction Between R and REDCap}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Encapsulates functions to streamline calls from R to the REDCap API. REDCap (Research Electronic Data CAPture) is a web application for building and managing online surveys and databases developed at Vanderbilt University. The Application Programming Interface (API) offers an avenue to access and modify data programmatically, improving the capacity for literate and reproducible programming.

Comprehensive documentation is also available at
https://ouhscbbmc.github.io/REDCapR/.

Much of this package has been developed to support the needs of the
following projects.  We appreciate the support.
\itemize{
\item \emph{OUHSC CCAN Independent Evaluation of the State of Oklahoma Competitive
Maternal, Infant, and Early Childhood Home Visiting
(\href{https://mchb.hrsa.gov/programs-impact/maternal-infant-early-childhood-home-visiting-miechv-program}{MIECHV}) Project}.
HRSA/ACF D89MC23154.
David Bard, PI, OUHSC; 2011-2015.
\item \emph{Independent Evaluation of the State of OK MIECHV Evidence Based Home
Visitation Project}, \href{https://www.nih.gov/}{NIH}-sponsored collaboration
with \href{https://oklahoma.gov/health.html}{OSDH}.
David Bard, PI, OUHSC; 2015-2017.
\item \emph{OSDH ParentPRO Pilot Evaluation}, federally-sponsored collaboration
with \href{https://oklahoma.gov/health.html}{OSDH}.
David Bard, PI, OUHSC; 2015-2017.
\item \emph{Title IV-E Waiver Project}, \href{https://mchb.hrsa.gov/}{HRSA/MCHB}-sponsored
collaboration with \href{https://oklahoma.gov/okdhs.html}{OKDHS};
David Bard, PI, OUHSC; 2014-2017.
\item \emph{Integrative Analysis of Longitudinal Studies of Aging (IALSA)},
sponsored by \href{https://grantome.com/grant/NIH/P01-AG043362-05}{NIH 5P01AG043362}.
Scott Hofer, PI, University of Victoria;
Will Beasley, PI of site-award, OUHSC; 2013-2018.
\item \emph{Oklahoma Shared Clinical and Translational Resources}, sponsored by
\href{https://grantome.com/grant/NIH/U54-GM104938}{NIH NIGMS; U54 GM104938}.
Judith A. James, PI, OUHSC; 2013-2018.
\item Additional Institutional Support from OUHSC
\href{https://medicine.ouhsc.edu/academic-departments/pediatrics}{Dept of Pediatrics};
2013-2017.
}
}
\note{
The release version is available through
\href{https://cran.r-project.org/package=REDCapR}{CRAN} by running
\code{install.packages('REDCapR')}.  The most recent development version is
available through \href{https://github.com/OuhscBbmc/REDCapR}{GitHub} by
running \code{remotes::install_github('OuhscBbmc/REDCapR')}
(make sure \href{https://cran.r-project.org/package=remotes}{remotes} is
already installed). If you're having trouble with the package, please
install the development version.  If this doesn't solve your problem,
please create a \href{https://github.com/OuhscBbmc/REDCapR/issues}{new issue},
or email Will.

See REDCapR's advanced vignette for information and examples for overriding
the default SSL options.
}
\examples{
\dontrun{
# Install/update REDCapR with the release version from CRAN.
# install.packages('REDCapR')

# Install/update REDCapR with the development version from GitHub
# install.packages("remotes") # Uncomment if `remotes` isn't installed already.
# remotes::install_github('OuhscBbmc/REDCapR')
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://ouhscbbmc.github.io/REDCapR/}
  \item \url{https://github.com/OuhscBbmc/REDCapR}
  \item \url{https://www.ouhsc.edu/bbmc/}
  \item \url{https://projectredcap.org}
  \item Report bugs at \url{https://github.com/OuhscBbmc/REDCapR/issues}
}

}
\author{
\strong{Maintainer}: Will Beasley \email{wibeasley@hotmail.com} (\href{https://orcid.org/0000-0002-5613-5006}{ORCID})

Other contributors:
\itemize{
  \item David Bard (\href{https://orcid.org/0000-0002-3922-8489}{ORCID}) [contributor]
  \item Thomas Wilson [contributor]
  \item John J Aponte \email{john.aponte@isglobal.org} [contributor]
  \item Rollie Parrish \email{rparrish@flightweb.com} (\href{https://orcid.org/0000-0001-8858-6381}{ORCID}) [contributor]
  \item Benjamin Nutter [contributor]
  \item Andrew Peters (\href{https://orcid.org/0000-0003-2487-1268}{ORCID}) [contributor]
  \item Hao Zhu (\href{https://orcid.org/0000-0002-3386-6076}{ORCID}) [contributor]
  \item Janosch Linkersdörfer (\href{https://orcid.org/0000-0002-1577-1233}{ORCID}) [contributor]
  \item Jonathan Mang (\href{https://orcid.org/0000-0003-0518-4710}{ORCID}) [contributor]
  \item Felix Torres \email{fetorres@ucsd.edu} [contributor]
  \item Philip Chase \email{pbc@ufl.edu} (\href{https://orcid.org/0000-0002-5318-9420}{ORCID}) [contributor]
  \item Victor Castro \email{vcastro@mgh.harvard.edu} (\href{https://orcid.org/0000-0001-7390-6354}{ORCID}) [contributor]
  \item Greg Botwin [contributor]
  \item Stephan Kadauke (\href{https://orcid.org/0000-0003-2996-8034}{ORCID}) [contributor]
  \item Ezra Porter (\href{https://orcid.org/0000-0002-4690-8343}{ORCID}) [contributor]
  \item Matthew Schuelke \email{matt@themadstatter.com} (\href{https://orcid.org/0000-0001-5755-1725}{ORCID}) [contributor]
}

}
\keyword{internal}
