/*
 * Decompiled with CFR 0.152.
 */
package javalain.tribes;

import java.util.ArrayList;
import java.util.Iterator;
import javalain.math.fonction.Fct;
import javalain.tribes.ParticuleTribes;
import javalain.tribes.TribuTribes;

public class EssaimTribe {
    private ArrayList<TribuTribes> swarm = new ArrayList();

    public EssaimTribe(Fct indice) {
        TribuTribes tr = new TribuTribes(this);
        tr.addParticule(new ParticuleTribes(indice));
        this.swarm.add(tr);
    }

    public TribuTribes getTribu(int i) {
        return this.swarm.get(i);
    }

    public int getNbTribus() {
        return this.swarm.size();
    }

    public int getNbParticules() {
        int cpt = 0;
        for (int i = 0; i < this.swarm.size(); ++i) {
            cpt += this.swarm.get(i).size();
        }
        return cpt;
    }

    public void updatePosition(boolean bool, int N) {
        for (int i = 0; i < this.swarm.size(); ++i) {
            this.swarm.get(i).updatePosition();
        }
    }

    public void updateBest() {
        for (int i = 0; i < this.swarm.size(); ++i) {
            this.swarm.get(i).updateBest();
        }
    }

    public ParticuleTribes getBestParticle() {
        ParticuleTribes global_best = this.swarm.get(0).getBestParticleOfTribe();
        double max = global_best.bestPerf;
        for (int i = 1; i < this.swarm.size(); ++i) {
            ParticuleTribes p = this.swarm.get(i).getBestParticleOfTribe();
            if (!(max < p.bestPerf)) continue;
            max = p.bestPerf;
            global_best = p;
        }
        return global_best;
    }

    public void adaptation(Fct indice) {
        ParticuleTribes super_shaman = this.getBestParticle();
        TribuTribes new_tribe = new TribuTribes(this);
        Iterator<TribuTribes> iterator = this.swarm.iterator();
        while (iterator.hasNext()) {
            TribuTribes tribu = iterator.next();
            ParticuleTribes shaman = tribu.getBestParticleOfTribe();
            if (!tribu.isGood()) {
                new_tribe.addParticule(new ParticuleTribes(indice));
                if (shaman != super_shaman) {
                    new_tribe.addParticule(new ParticuleTribes(indice, super_shaman, shaman));
                    continue;
                }
                new_tribe.addParticule(new ParticuleTribes(indice));
                continue;
            }
            if (tribu.size() == 1) {
                if (shaman == super_shaman) continue;
                iterator.remove();
                continue;
            }
            tribu.supprimePireParticule();
        }
        if (new_tribe.size() != 0) {
            this.swarm.add(new_tribe);
        }
    }

    public int nbLiens() {
        int cpt = 0;
        for (int i = 0; i < this.swarm.size(); ++i) {
            cpt += this.swarm.get(i).size() * this.swarm.get(i).size();
        }
        return cpt + this.getNbTribus() * (this.getNbTribus() - 1);
    }
}

