/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.randvar.BetaGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class BetaRejectionLoglogisticGen
extends BetaGen {
    private RandomStream auxStream;
    private static final int bb = 0;
    private static final int bc = 1;
    private double am;
    private double bm;
    private double al;
    private double alnam;
    private double be;
    private double ga;
    private double si;
    private double rk1;
    private double rk2;

    public BetaRejectionLoglogisticGen(RandomStream randomStream, RandomStream randomStream2, BetaDist betaDist) {
        super(randomStream, betaDist);
        this.auxStream = randomStream2;
        this.init();
    }

    public BetaRejectionLoglogisticGen(RandomStream randomStream, BetaDist betaDist) {
        this(randomStream, randomStream, betaDist);
    }

    public RandomStream getAuxStream() {
        return this.auxStream;
    }

    private void init() {
        BetaDist betaDist = (BetaDist)this.dist;
        this.p = betaDist.getAlpha();
        this.q = betaDist.getBeta();
        if (this.p > 1.0 && this.q > 1.0) {
            this.gen = 0;
            this.am = this.p < this.q ? this.p : this.q;
            this.bm = this.p > this.q ? this.p : this.q;
            this.al = this.am + this.bm;
            this.be = Math.sqrt((this.al - 2.0) / (2.0 * this.p * this.q - this.al));
            this.ga = this.am + 1.0 / this.be;
        } else {
            this.gen = 1;
            this.am = this.p > this.q ? this.p : this.q;
            this.bm = this.p < this.q ? this.p : this.q;
            this.al = this.am + this.bm;
            this.alnam = this.al * Math.log(this.al / this.am) - 1.386294361;
            this.be = 1.0 / this.bm;
            this.si = 1.0 + this.am - this.bm;
            this.rk1 = this.si * (0.013888889 + 0.041666667 * this.bm) / (this.am * this.be - 0.77777778);
            this.rk2 = 0.25 + (0.5 + 0.25 / this.si) * this.bm;
        }
    }

    public double nextDouble() {
        double d = 0.0;
        RandomStream randomStream = this.stream;
        block0 : switch (this.gen) {
            case 0: {
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                double d8;
                double d9;
                do {
                    d6 = randomStream.nextDouble();
                    d3 = randomStream.nextDouble();
                    randomStream = this.auxStream;
                } while ((d9 = this.am + (d8 = this.ga * (d7 = this.be * Math.log(d6 / (1.0 - d6))) - 1.386294361) - (d5 = this.am * Math.exp(d7))) + 2.609437912 < 5.0 * (d4 = d6 * d6 * d3) && d9 < (d2 = Math.log(d4)) && d8 + this.al * Math.log(this.al / (this.bm + d5)) < d2);
                d = BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? d5 / (this.bm + d5) : this.bm / (this.bm + d5);
                break;
            }
            case 1: {
                double d10;
                while (true) {
                    double d11;
                    double d12;
                    double d13 = randomStream.nextDouble();
                    double d14 = randomStream.nextDouble();
                    randomStream = this.auxStream;
                    if (d13 < 0.5) {
                        double d15 = d13 * d14;
                        d12 = d13 * d15;
                        if (0.25 * d14 - d15 + d12 >= this.rk1) continue;
                        d11 = this.be * Math.log(d13 / (1.0 - d13));
                        if (d11 > 80.0) {
                            if (this.alnam < Math.log(d12)) continue;
                            d = BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? 1.0 : 0.0;
                            break block0;
                        }
                        d10 = this.am * Math.exp(d11);
                        if (this.al * (Math.log(this.al / (this.bm + d10)) + d11) - 1.386294361 < Math.log(d12)) continue;
                        d = !BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? this.bm / (this.bm + d10) : d10 / (this.bm + d10);
                        break block0;
                    }
                    d12 = d13 * d13 * d14;
                    if (d12 < 0.25) {
                        d11 = this.be * Math.log(d13 / (1.0 - d13));
                        if (d11 > 80.0) {
                            d = BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? 1.0 : 0.0;
                            break block0;
                        }
                        d10 = this.am * Math.exp(d11);
                        d = !BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? this.bm / (this.bm + d10) : d10 / (this.bm + d10);
                        break block0;
                    }
                    if (d12 >= this.rk2) continue;
                    d11 = this.be * Math.log(d13 / (1.0 - d13));
                    if (d11 > 80.0) {
                        if (this.alnam < Math.log(d12)) continue;
                        d = BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? 1.0 : 0.0;
                        break block0;
                    }
                    d10 = this.am * Math.exp(d11);
                    if (!(this.al * (Math.log(this.al / (this.bm + d10)) + d11) - 1.386294361 < Math.log(d12))) break;
                }
                d = !BetaRejectionLoglogisticGen.equalsDouble(this.am, this.p) ? this.bm / (this.bm + d10) : d10 / (this.bm + d10);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this.a + (this.b - this.a) * d;
    }

    private static boolean equalsDouble(double d, double d2) {
        if (d == d2) {
            return true;
        }
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        return Math.abs(d - d2) <= Math.min(d3, d4) * 2.220446049250313E-16;
    }
}

