% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tightness.R
\name{tightness}
\alias{tightness}
\title{Tightness function}
\usage{
tightness(samp = NULL, prob = NULL, quant = NULL, k = NULL)
}
\arguments{
\item{samp}{Sample of data to model}

\item{prob}{Probability of interest}

\item{quant}{Quantile of interest}

\item{k}{value of k to check tightness}
}
\value{
Returns the squared difference between the tightness and 1
}
\description{
\code{tightness} function used to minimized the tightness as a function of the value of k
}
\examples{
samp <- rnorm(1e3, mean = 100, sd = 10)
prob <- c(1-1e-2)
k <- 1:100
quant <- qnorm(p = prob, mean = 100, sd = 10)
tightness(samp = samp, prob = prob, quant = quant, k = k)
}
\keyword{RESTK}
