% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemSig.R
\name{chemSig}
\alias{chemSig}
\title{Chemical Variable Selection within the Floating Percentile Model}
\usage{
chemSig(
  data,
  paramList,
  testType = NULL,
  alpha = 0.05,
  alternative = "less",
  var.alternative = "two.sided",
  var.equal = NULL,
  warn = TRUE,
  ExcelMode = NULL
)
}
\arguments{
\item{data}{data.frame containing, at a minimum, chemical concentrations as columns and a logical \code{Hit} column classifying toxicity}

\item{paramList}{character vector of column names of chemical concentration variables in \code{data}}

\item{testType}{character string; whether to run parametric or non-parametric tests (default = \code{NULL}). See Details for more information.}

\item{alpha}{numeric value between 0 and 1; type-I error rate for hypothesis testing (default = \code{0.05})}

\item{alternative}{alternative hypothesis type for equality of central tendency (default = \code{"less"})}

\item{var.alternative}{alternative hypothesis type for equal variance test (default = \code{"two.sided"})}

\item{var.equal}{logical; whether to assume equal variance (default = \code{NULL})}

\item{warn}{logical; whether to generate a warning associated with \code{ExcelMode} (default = \code{TRUE})}

\item{ExcelMode}{logical; whether to force \code{chemSig} to run like the WA Department of Ecology's Excel-based floating percentile model calculator (default = \code{FALSE})}
}
\value{
named logical vector
}
\description{
Determine which chemicals in a dataset have significantly higher concentrations
among toxic samples by comparison to non-toxic samples
}
\details{
\code{chemSig} is called within \code{FPM} via \code{chemSigSelect}, which generates a subset of chemicals to
pass into the floating percentil model algorithm. \code{chemSig} only returns a logical vector describing which parameters in \code{paramList} should be selected for
benchmark development based on having significantly higher concentrations when \code{Hit == TRUE} than when \code{Hit == FALSE}.
The user has the ability to manipulate several of the parameters of the selection algorithm, or they can allow \code{chemSig} to test for
assumptions and use appropriate hypothesis tests based on those results. By default, \code{chemSig} will use \code{shapiro.test} to
confirm normality, then either \code{var.test} if the data are normal or \code{fligner.test}
if the data are non-normal to confirm equal variance. Finally, the function will use \code{t.test} if the data are normal (using the Welch method if unequal variance),
\code{wilcox.test} if non-normal with equal variance, or \code{brunner.munzel.test} if non-normal with unequal variance.

The \code{testType} argument can be one of \code{p}, \code{P}, \code{param}, \code{Param}, \code{parametric}, or \code{Parametric} for parametric
test types or \code{non}, \code{Non}, \code{np}, \code{NP}, \code{nonparam}, \code{Nonparam}, \code{non-param}, \code{Non-param}, \code{nonparametric}, \code{Nonparametric},
\code{non-parametric}, \code{Non-parametric}, or \code{Non-Parametric}.

Only a single \code{alpha} level can be supplied; it is currently applied to all tests.

While \code{alternative} and \code{var.alternative} can be adjusted, we strongly recommend that they not be changed from the
default values. For example, changing \code{alternative} from \code{"less"} (default) to \code{"two.sided"} would result in
the assumption that chemical concentrations could be significantly higher (as well as lower) when there is no toxicity than when there is, which is inappropriate.
The "greater" alternative, which is never appropriate, is not an accepted input for \code{alternative}. Similarly, the
assumption of equal variance relates to a \code{"two.sided"} argument, therefore changing the \code{var.alternative} to be
\code{"less"} or \code{"greater"} would not be appropriate.

\code{ExcelMode} assumes \code{testType = "parametric"}, \code{var.equal = TRUE}, \code{alternative = "less"}, and \code{alpha = 0.1}. In
actuality, the Excel-based tool uses a one-way ANOVA test to compare two levels of \code{Hit}, which is equivalent to a t-test so long as alpha is adjusted to 0.1.
Thus, \code{testType}, \code{alternative}, \code{var.alternative}, and \code{var.equal} are overridden when \code{ExcelMode = TRUE}.
This argument was included for those interested in using 'RFPM' as an alternative to the Excel-based calculator tool to obtain identical benchmark results.
}
\examples{
paramList = c("Cd", "Cu", "Fe", "Mn", "Ni", "Pb", "Zn")
chemSig(data = h.tristate, paramList = paramList, testType = "nonparametric")
chemSig(data = h.tristate, paramList = paramList, testType = "parametric")
}
