% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimFPM.R
\name{optimFPM}
\alias{optimFPM}
\title{Optimization of Floating Percentile Model Parameters}
\usage{
optimFPM(
  data,
  paramList,
  plot = TRUE,
  FN_crit = seq(0.1, 0.9, by = 0.05),
  alpha = seq(0.05, 0.5, by = 0.05),
  simplify = TRUE,
  which = c(1, 2),
  colors = heat.colors(10),
  colsteps = 100,
  ...
)
}
\arguments{
\item{data}{data.frame containing, at a minimum, chemical concentrations as columns and a logical \code{Hit} column classifying toxicity}

\item{paramList}{character vector of column names of chemical concentration variables in \code{data}}

\item{plot}{logical; whether to generate a plot to visualize the opimization results}

\item{FN_crit}{numeric vector over which to optimize false negative thresholds (default = \code{seq(0.1, 0.9, by = 0.05))}}

\item{alpha}{numeric vector of type-I error rate values over which to optimize (default = \code{seq(0.05, 0.5, by = 0.05))}}

\item{simplify}{logical; whether to export only optimized values or the full results of optimization}

\item{which}{numeric or character indicating which type of plot to generate (see Details; default = \code{c(1, 2)})}

\item{colors}{values recognizable as colors - text, hexadecimal, numbers, etc. (default = \code{heat.colors(10)}).}

\item{colsteps}{numeric value, number of unique colors to include in gradient (default = \code{100})}

\item{...}{additional argument passed to \code{FPM}, \code{chemSig}, and \code{chemSigSelect}}
}
\value{
data.frame of optimized \code{FN_crit} and/or \code{alpha} values
}
\description{
Calculate parameter inputs that optimize benchmark performance
}
\details{
\code{optimFPM} was designed to help optimize the predictive capacity of the benchmarks generated by \code{FPM}. The default input parameters to
\code{FPM} (i.e., \code{FN_crit = 0.2} and \code{alpha = 0.05}) are arbitrary, and optimization can help to objectively establish more accurate benchmarks.
Graphical output from \code{optimFPM} can also help users to understand the relationship(s) between benchmark accuracy/error, \code{FN_crit}, and \code{alpha}.
We also recommend that users apply \code{cvFPM} to their data to further inform the selection of \code{FPM} input values.

Default inputs for \code{FN_crit} and \code{alpha} were selected to represent a reasonable range of values to test. Testing over both ranges
will result in a two-way optimization, which can be computationally intensive. Alternatively, \code{optimFPM} can be run for one parameter at a time
by specifying a single value for \code{FN_crit} or \code{alpha}. Note that inputting single values for both \code{FN_crit} and \code{alpha} will generate unhelpful results.

Two metrics are used for optimization, one based on the maximum overall reliability (i.e., highest probability of correctly
predicting \code{Hit} values) and one based on minimizing the difference between the false negative and false positive rates,
which represents a trade-off between under- and overconservatism.

Graphical output will differ depending on whether or not a single value is input for \code{FN_crit} or \code{alpha}. Providing a single value for one
of the two arguments will generate a line graph, whereas providing longer vectors (i.e., length > 1) of inputs for both arguments will generate dot matrix plots using \code{colors} to generate
a color palette and \code{colsteps} to define the granularity of the color gradient with the palette. The order of \code{colors} will be plotted
from more optimal to less optimal; for example, the default of \code{heat.colors(10)} will show optimal colors as red and less optimal colors as yellower.
By default, two plots will be generated, however the \code{which} argument can control whether to include either or both plots. Inputs
to \code{which} are, by default, \code{c(1, 2)}, but flexible character inputs also can be used, for example \code{which = "OR"} or \code{which = "balanced"}.
Black and gray squares indicate the optimal argument values (black for the indicated optimization metric and gray for the other metric).
}
\examples{
paramList = c("Cd", "Cu", "Fe", "Mn", "Ni", "Pb", "Zn")
FN_seq <- seq(0.1, 0.3, 0.05)
alpha_seq <- seq(0.05, 0.2, 0.05)
optimFPM(data = h.tristate, paramList = paramList, alpha = 0.05, FN_crit = FN_seq)
optimFPM(data = h.tristate, paramList = paramList, FN_crit = 0.2, alpha = alpha_seq)
optimFPM(data = h.tristate, paramList = paramList, alpha = alpha_seq, FN_crit = FN_seq, which = 2)
}
\seealso{
FPM, cvFPM
}
