% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digitizeRadii.R
\name{digitizeRadii}
\alias{digitizeRadii}
\title{Collect radial measurements from a calcified structure by interactively selecting annuli}
\usage{
digitizeRadii(img, id, reading, suffix, description, edgeIsAnnulus, popID,
  IDpattern, IDreplace, windowSize, deviceType, closeWindow, scaleBar,
  scaleBarLength, col.scaleBar, lwd.scaleBar, scalingFactor, makeTransect,
  snap2Transect, col.transect, lwd.transect, pch.sel, col.sel, cex.sel,
  pch.del, col.del, showInfo, pos.info, cex.info, col.info)
}
\arguments{
\item{img}{A vector of strings that indicates the image (must be PNG, JPG, BMP, or TIFF) to be loaded and plotted. By default the user will be provided a dialog box from which to choose the file(s). Alternatively the user can supply the name(s) of the file(s). Either way the file(s) must be in the current working directory.}

\item{id}{A vector of unique identifiers for the fish or structure(s) being examined. Will be coerced to a character. If length of \code{img} is greater than 1, then the length of \code{id} must be the same. If missing then you will be prompted to enter a value.}

\item{reading}{See details in \code{\link{RFBCoptions}}.}

\item{suffix}{See details in \code{\link{RFBCoptions}}.}

\item{description}{See details in \code{\link{RFBCoptions}}.}

\item{edgeIsAnnulus}{See details in \code{\link{RFBCoptions}}.}

\item{popID}{See details in \code{\link{RFBCoptions}}.}

\item{IDpattern}{See details in \code{\link{RFBCoptions}}.}

\item{IDreplace}{See details in \code{\link{RFBCoptions}}.}

\item{windowSize}{See details in \code{\link{RFBCoptions}}.}

\item{deviceType}{See details in \code{\link{RFBCoptions}}.}

\item{closeWindow}{See details in \code{\link{RFBCoptions}}.}

\item{scaleBar}{See details in \code{\link{RFBCoptions}}.}

\item{scaleBarLength}{See details in \code{\link{RFBCoptions}}.}

\item{col.scaleBar}{See details in \code{\link{RFBCoptions}}.}

\item{lwd.scaleBar}{See details in \code{\link{RFBCoptions}}.}

\item{scalingFactor}{See details in \code{\link{RFBCoptions}}.}

\item{makeTransect}{See details in \code{\link{RFBCoptions}}.}

\item{snap2Transect}{See details in \code{\link{RFBCoptions}}.}

\item{col.transect}{See details in \code{\link{RFBCoptions}}.}

\item{lwd.transect}{See details in \code{\link{RFBCoptions}}.}

\item{pch.sel}{See details in \code{\link{RFBCoptions}}.}

\item{col.sel}{See details in \code{\link{RFBCoptions}}.}

\item{cex.sel}{See details in \code{\link{RFBCoptions}}.}

\item{pch.del}{See details in \code{\link{RFBCoptions}}.}

\item{col.del}{See details in \code{\link{RFBCoptions}}.}

\item{showInfo}{See details in \code{\link{RFBCoptions}}.}

\item{pos.info}{See details in \code{\link{RFBCoptions}}.}

\item{cex.info}{See details in \code{\link{RFBCoptions}}.}

\item{col.info}{See details in \code{\link{RFBCoptions}}.}
}
\value{
\code{NULL} if more than one file was given in \code{img} or, if only one file was given, a list that contains the following:
\itemize{
  \item{\code{image}: }{The full filename given in \code{img}.}
  \item{\code{datanm}: }{The R data filename.}
  \item{\code{description}: }{The description given in \code{description}.}
  \item{\code{edgeIsAnnulus}: }{The logical given in \code{edgeIsAnnulus} that identified whether the structure edge/margin should be considered as an annulus.}
  \item{\code{snap2Transect}: }{The logical from \code{snap2Transect} that identified whether the selected points were \dQuote{snapped} to the transect or not.}
  \item{\code{scalingFactor}: }{A single numeric used to convert measurements on the structure image to actual measurements on the structure. Measurements on the structure image were multiplied by this value.}
  \item{\code{sfSource}: }{A character string that identifies whether the scaling factor was \code{"Provided"} through the \code{scalingFactor} argument or derived from a \code{"scaleBar"}.}
  \item{\code{sbPts}: }{A data.frame of \code{x} and \code{y} coordinates for the endpoints of the scale-bar if the scaling factor was derived from a scale-bar.}
  \item{\code{sbLength}: }{A single numeric that is the known (actual) length of the scale-bar if the scaling factor was derived from a scale-bar.}
  \item{\code{slpTransect}: }{The slope of the transect.}
  \item{\code{intTransect}: }{The intercept of the transect.}
  \item{\code{slpPerpTransect}: }{The slope of the line perpendicular to the transect.}
  \item{\code{windowSize}: }{A numeric of length two that contains the width and height of the window used to display the structure image. One of these units was set by the given \code{windowSize} value.}
  \item{\code{pixW2H}: }{The ratio of pixel width to height. This is used to correct measurements for when an image is not square.}
  \item{\code{pts}: }{A data.frame that contains the \code{x} and \code{y} coordinates on the image for the selected annuli. These points may have been \dQuote{snapped} to the transect if \code{snap2Transect==TRUE}.}
  \item{\code{radii}: }{A data.frame that contains the unique \code{id}, the \code{reading} code, the age-at-capture in \code{agecap}, the annulus number in \code{ann}, the radial measurements in \code{rad}, and the radial measurement at capture in \code{radcap}.}
}.
}
\description{
The user interactively select points on an image of a calcified structure. When finished, radial measurements (from the structure focus to the selected points) are calculated (either with arbitrary units or actual units if a scale-bar is included on the image) and written to an external file for later use.
}
\details{
This function requires interaction from the user. A detailed description of its use is in the vignettes on the \href{http://derekogle.com/RFishBC/index.html}{RFishBC website}.
}
\examples{
## None because this requires interaction from the user.
## See the link to the extensive documentation in the Details.

}
\seealso{
\code{\link{showDigitizedImage}} and \code{\link{RFBCoptions}}.
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}.
}
