% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f.fit.R
\name{f.fit}
\alias{f.fit}
\title{fit a spline to the histogram of imp}
\usage{
f.fit(imp, df = 10, debug.flag = 0, temp.dir = NULL)
}
\arguments{
\item{imp}{the variable importances}

\item{df}{the degrees of freedom for the spline fit}

\item{debug.flag}{either 0 (no debugging information), 1 or 2}

\item{temp.dir}{if debug flag is >0 then information is written to temp.dir}
}
\value{
a list with the following components
\itemize{
\item "x" -- midpoints of the histogram
\item "zh" -- a histogram object as returned by "hist"
\item "f.spline" -- the spline fit. The fit is given by a glm mode glm(zh$counts ~ splines::ns(x), poisson)
\item "counts" the counts from the histogram
}
}
\description{
fit a spline to the histogram of imp
}
\examples{
data(imp20000)
imp <- log(imp20000$importances)
res <- f.fit(imp)
plot(res$zh, xlab="importances", main="histogram of importances")
points(res$midpoints,res$counts, col="grey90")
lines(res$zh$breaks[-1],res$f.spline,col="blue", lwd=3)
legend("topleft",c("spline fit"), col="blue", lwd=3)
}
\keyword{spline}
