% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFTuning.R
\name{plotOOBvsMTRY}
\alias{plotOOBvsMTRY}
\title{Plotting the average OOB error and its 95\% confidence interval as a function of the mtry parameter}
\usage{
plotOOBvsMTRY(mean_matrix, ci_matrix)
}
\arguments{
\item{mean_matrix}{a 1 x p matrix where p is the number of mtry values tested. Each value represents the average
OOB error obtained training multiple Random Forest models with a defined value of mtry}

\item{ci_matrix}{a 2 x p matrix containing the extremes of the confidence interval of the average OOB error.}
}
\value{
a graphical representation of the average OOB error as a function of the mtry parameter.
}
\description{
Plotting the average OOB error and its 95\% confidence interval as a function of the mtry parameter
}
\examples{
## data(cachexiaData)
## res <- tuneMTRY(cachexiaData, iterations = 5, maxntree = 600, mtry_length = 10, graph = F)
## l <- optimizeMTRY(res$oob)
## plotOOBvsMTRY(l$mean_matrix, l$ci_matrix)
}
\author{
Piergiorgio Palla
}

