/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover.generalstring;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.graph.OperatorGraph;
import freak.core.population.Individual;
import freak.module.operator.crossover.MultiPairwiseCrossover;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;

public class RandomRespectfulCrossover
extends MultiPairwiseCrossover {
    public RandomRespectfulCrossover(OperatorGraph graph) {
        super(graph);
    }

    protected Individual doCrossover(Individual ind1, Individual ind2) {
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int[] gs1 = ((GeneralStringGenotype)ind1.getGenotype()).getIntArray();
        int[] gs2 = ((GeneralStringGenotype)ind2.getGenotype()).getIntArray();
        int[] gsOut = (int[])gs1.clone();
        int n = ((GeneralString)this.graph.getSchedule().getGenotypeSearchSpace()).getDimension();
        int numChars = ((GeneralString)this.graph.getSchedule().getGenotypeSearchSpace()).getNumChars();
        int i = 0;
        while (i < n) {
            if (gs1[i] != gs2[i]) {
                gsOut[i] = re.choose(0, numChars - 1);
            }
            ++i;
        }
        return new Individual(this.graph.getSchedule(), new GeneralStringGenotype(gsOut, numChars), new Individual[]{ind1, ind2});
    }

    public String getDescription() {
        return "The positions which are identical in both parents are taken over. The characters at the other positions are chosen at random.";
    }

    public String getName() {
        return "Random Respectful Crossover";
    }
}

