% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/goals.R
\name{get_goal}
\alias{get_goal}
\title{Gets a goal to which the user has access to}
\usage{
get_goal(account.id, webproperty.id, profile.id, goal.id, token)
}
\arguments{
\item{account.id}{integer or character. Account ID to retrieve the goal for.}

\item{webproperty.id}{character. Web property ID to retrieve the goal for.}

\item{profile.id}{ineger or character. View (Profile) ID to retrieve the goal for.}

\item{goal.id}{ineger or character. Goal ID to retrieve the goal for.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
An Analytics goal resource
\item{id}{Goal ID.}
\item{kind}{Resource type for an Analytics goal.}
\item{self.link}{Link for this goal.}
\item{account.id}{Account ID to which this goal belongs.}
\item{webproperty.id}{Web property ID to which this goal belongs. The web property ID is of the form UA-XXXXX-YY.}
\item{internal.webproperty.id}{Internal ID for the web property to which this goal belongs.}
\item{profile.id}{View (Profile) ID to which this goal belongs.}
\item{name}{Goal name.}
\item{value}{Goal value.}
\item{active}{Determines whether this goal is active.}
\item{type}{Goal type. Possible values are URL_DESTINATION, VISIT_TIME_ON_SITE, VISIT_NUM_PAGES, and EVENT.}
\item{created}{Time this goal was created.}
\item{updated}{Time this goal was last modified.}
\item{parent.link}{Parent link for a goal. Points to the view (profile) to which this goal belongs.}
\item{visit.time.on.site.details}{Details for the goal of the type VISIT_TIME_ON_SITE.}
}
\description{
Gets a goal to which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/goals}{Management API - Goals}
}
\seealso{
\code{\link{authorize}}

Other Management API: \code{\link{get_custom_dimension}};
  \code{\link{get_custom_metric}};
  \code{\link{get_experiment}}; \code{\link{get_filter}};
  \code{\link{get_profile}};
  \code{\link{get_unsampled_report}};
  \code{\link{get_upload}}; \code{\link{get_webproperty}};
  \code{\link{list_accounts}};
  \code{\link{list_custom_dimensions}};
  \code{\link{list_custom_metrics}};
  \code{\link{list_custom_sources}};
  \code{\link{list_experiments}};
  \code{\link{list_filters}}; \code{\link{list_goals}};
  \code{\link{list_profiles}}; \code{\link{list_segments}};
  \code{\link{list_unsampled_reports}};
  \code{\link{list_uploads}};
  \code{\link{list_webproperties}}
}

