% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_space.R
\name{.SSSystem}
\alias{.SSSystem}
\title{Prepares state space model system matrices to create an object of type \code{NAWRUmodel}
or \code{TFPmodel}.}
\usage{
.SSSystem(tsl, cycle, trend, cycleLag, type = NULL, errorARMA)
}
\arguments{
\item{tsl}{A list of input time series computed during the procedure \code{NAWRUmodel}
or \code{TFPmodel}.}

\item{cycle}{A character string specifying the cycle model. \code{cycle = "AR1"} denotes
an AR(1) process, \code{cycle = "AR2"} an \code{AR(2)} process. The default is
\code{cycle = "AR2"}.}

\item{trend}{A character string specifying the trend model. \code{trend = "RW1"} denotes
a first order random walk, \code{trend = "RW2"} a second order random walk (local linear
trend) and \code{trend = "DT"} a damped trend model. The default is \code{trend = "RW2"}.}

\item{cycleLag}{A vector specifying the cycle lags that are included in the Phillip's
curve. The default is \code{cycleLag = 0}, see details.}

\item{type}{A character string specifying the type of the Phillip's curve.
\code{type = "TKP"} denotes the traditional Keynesian Phillip's curve and
\code{type = "NKP"} the New Keynesian Phillip's curve, see details. The default is
\code{type = "TKP"}.}

\item{errorARMA}{A vector with non-negative integers specifying the AR and MA degree of
the error term in the second observation equation.}
}
\description{
Prepares state space model system matrices to create an object of type \code{NAWRUmodel}
or \code{TFPmodel}.
}
\keyword{internal}
