% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{obs2Optim}
\alias{obs2Optim}
\title{Find suitable 2nd observation specification}
\usage{
obs2Optim(
  x1,
  x2,
  xexo = NULL,
  errorARmax = 2,
  errorMAmax = 2,
  maxCycleLag = 2,
  maxAR = 2,
  nModels = 1
)
}
\arguments{
\item{x1}{A time series, the second observation equation.}

\item{xexo}{(Optional) A (multiple) time series with exogenous variables.}

\item{errorARmax}{Integer, maximal AR order of the error process of the 2nd observation 
equation.}

\item{errorMAmax}{Integer, maximal MA order of the error process of the 2nd observation 
equation.}

\item{maxCycleLag}{Integer, maximal cycle lag included in the 2nd observation 
equation.}

\item{maxAR}{Integer, maximal AR order of the time series \code{x2} in the 2nd observation 
equation. \code{0} means that no lag is included.}

\item{nModels}{Integer, maximum number of models chosen to be fitted.}

\item{BIC}{Bayesian information criterion of chosen model.}
}
\value{
A list containing the chosen parameters: \code{errorAR, errorMA, cycleLag, ar, exo}.
}
\description{
Finds the most suitable model for the second observation equation according 
to the BIC.
}
\keyword{internal}
