% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bootstrap.r
\name{plot.bootstrap}
\alias{plot.bootstrap}
\title{Plot a fitted rgcca_bootstrap object}
\usage{
\method{plot}{bootstrap}(
  x,
  block = seq_along(x$rgcca$call$blocks),
  comp = 1,
  type = "weights",
  empirical = TRUE,
  n_mark = 30,
  display_order = TRUE,
  show_stars = TRUE,
  title = NULL,
  cex = 1,
  cex_sub = 12 * cex,
  cex_main = 14 * cex,
  cex_lab = 12 * cex,
  cex_point = 3 * cex,
  colors = NULL,
  adj.method = "fdr",
  ...
)
}
\arguments{
\item{x}{A fitted rgcca_bootstrap object
(see \code{\link[RGCCA]{rgcca_bootstrap}})}

\item{block}{A numeric corresponding to the block(s) to plot.}

\item{comp}{A numeric vector indicating the component(s) to consider.}

\item{type}{A string indicating the bootstrapped object to plot:
block-weight vectors ("weights", default) or block-loading vectors
("loadings").}

\item{empirical}{A logical value indicating if the bootstrap confidence
intervals and p-values are derived from the empirical distribution.
(default: TRUE)}

\item{n_mark}{An integer defining the maximum number of variables to plot.}

\item{display_order}{A logical value for ordering the variables. If TRUE,
variables are ordered from highest to lowest absolute value. If FALSE,
the block order is used. Default is TRUE.}

\item{show_stars}{A logical value indicating if the significance levels
are displayed.}

\item{title}{A string specifying the title of the plot.}

\item{cex}{A numeric defining the size of the objects in the plot. Default
is one.}

\item{cex_sub}{A numeric defining the font size of the subtitle. Default is
12 * cex.}

\item{cex_main}{A numeric defining the font size of the title. Default is
14 * cex.}

\item{cex_lab}{A numeric defining the font size of the labels. Default is
12 * cex.}

\item{cex_point}{A numeric defining the font size of the points. Default is
3 * cex.}

\item{colors}{Colors used in the plots.}

\item{adj.method}{A string indicating the method used to adjust the p-values.
It must be a method handled by the p.adjust function. Default is "fdr".}

\item{...}{Additional graphical parameters.}
}
\value{
A ggplot2 plot object.
}
\description{
Plot the results of a fitted rgcca_bootstrap object. Each block variable
is shown along with its associated bootstrap confidence interval and
stars reflecting the p-value of assigning a strictly positive or
negative weight to this block variable.
}
\examples{
data("Russett")
blocks <- list(
  agriculture = Russett[, seq(3)],
  industry = Russett[, 4:5],
  politic = Russett[, 6:11]
)
fit.rgcca <- rgcca(blocks, ncomp = 2, method = "rgcca", tau = 1)
fit.boot <- rgcca_bootstrap(fit.rgcca, n_boot = 20, n_cores = 1,
                            verbose = FALSE)
plot(fit.boot, type = "weight", block = 1, comp = 1)
}
