% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twod_cow.R
\name{twod_cow}
\alias{twod_cow}
\title{Two-dimensional correlation optimized warping alignment}
\usage{
twod_cow(sample_chrom, ref_chrom, segments, max_warp)
}
\arguments{
\item{sample_chrom}{A GCxGC class cromatogram obtained by read_chrom 
function.}

\item{ref_chrom}{A representative GCxGC chromatogram choosen to be the 
template which sample_chrom will be aligned.}

\item{segments}{A two integer vector with number of segments
which the first and second dimension will be subdivided, respectively.}

\item{max_warp}{A two integer vector with the maximum warping parameter.}
}
\description{
`twod_cow` returns the bidimensional correlation optimised warping aligmened
 sample chromatogram versus a reference chromatogram.
}
\details{
This is an adaptation of bidimesional COW aligment first implementated 
in MATLAB \insertCite{Tomasi2004}{RGCxGC}. 
This functions takes a sample chromatogram to be aligned 
to reference one. The argument [segment] will be used to split the whole
chromatogram in n parts in the first and the second dimension respectevily.
The [max_warp] argument provides de maxium tolerace of the signal
transformation as well to the firs and the second dimension
\insertCite{DabaoZhang2008}{RGCxGC}.
}
\examples{

library(colorRamps)
GB08_fl <- system.file("extdata", "08GB.cdf", package = "RGCxGC")
GB09_fl <- system.file("extdata", "09GB.cdf", package = "RGCxGC")
GB08 <- read_chrom(GB08_fl, 5L)
GB09 <- read_chrom(GB09_fl, 5L)
\donttest{
GB09_al <- twod_cow(GB09, GB08, c(20, 40), c(2, 8))
}

}
\references{
\insertAllCited{}
}
